/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.luminis.quic.PnSpace;
import net.luminis.quic.Version;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.send.Sender;

public class AckGenerator {
    private final Version quicVersion = Version.getDefault();
    private final PnSpace pnSpace;
    private final Sender sender;
    private List<Long> packetsToAcknowledge = new ArrayList<Long>();
    private boolean newPacketsToAcknowledge;
    private Instant newPacketsToAcknowlegdeSince;
    private Map<Long, AckFrame> ackSentWithPacket = new HashMap<Long, AckFrame>();
    private int acksNotSend = 0;

    public AckGenerator(PnSpace pnSpace, Sender sender) {
        this.pnSpace = pnSpace;
        this.sender = sender;
    }

    public synchronized boolean hasAckToSend() {
        return !this.packetsToAcknowledge.isEmpty();
    }

    public synchronized boolean hasNewAckToSend() {
        return this.newPacketsToAcknowledge;
    }

    public synchronized void packetReceived(QuicPacket packet) {
        if (packet.canBeAcked()) {
            this.packetsToAcknowledge.add(packet.getPacketNumber());
            if (packet.isAckEliciting()) {
                this.newPacketsToAcknowledge = true;
                if (this.newPacketsToAcknowlegdeSince == null) {
                    this.newPacketsToAcknowlegdeSince = Instant.now();
                }
                if (this.pnSpace != PnSpace.App) {
                    this.sender.sendAck(this.pnSpace, 0);
                } else {
                    int ackFrequency = 2;
                    ++this.acksNotSend;
                    if (this.acksNotSend >= ackFrequency) {
                        this.sender.sendAck(this.pnSpace, 0);
                        this.acksNotSend = 0;
                    } else {
                        this.sender.sendAck(this.pnSpace, 20);
                    }
                }
            }
        }
    }

    public synchronized void process(QuicFrame receivedAck) {
        ((AckFrame)receivedAck).getAckedPacketNumbers().stream().filter(pn -> this.ackSentWithPacket.containsKey(pn)).limit(1L).forEach(pn -> {
            AckFrame ackSent = this.ackSentWithPacket.get(pn);
            ackSent.getAckedPacketNumbers().forEach(ackedPacket -> this.packetsToAcknowledge.remove(ackedPacket));
        });
    }

    public synchronized Optional<AckFrame> generateAckForPacket(long packetNumber) {
        Optional<AckFrame> ackFrame = this.generateAck();
        if (ackFrame.isPresent()) {
            this.registerAckSendWithPacket(ackFrame.get(), packetNumber);
        }
        return ackFrame;
    }

    public synchronized Optional<AckFrame> generateAck() {
        List<Long> packetsToAck;
        int delay = 0;
        if (this.newPacketsToAcknowlegdeSince != null && this.pnSpace == PnSpace.App && (delay = (int)Duration.between(this.newPacketsToAcknowlegdeSince, Instant.now()).toMillis()) < 0) {
            delay = 0;
        }
        if (!(packetsToAck = this.packetsToAcknowledge).isEmpty()) {
            return Optional.of(new AckFrame(this.quicVersion, this.packetsToAcknowledge, delay));
        }
        return Optional.empty();
    }

    public synchronized void registerAckSendWithPacket(AckFrame ackFrame, long packetNumber) {
        this.ackSentWithPacket.put(packetNumber, ackFrame);
        this.newPacketsToAcknowledge = false;
        this.newPacketsToAcknowlegdeSince = null;
        this.acksNotSend = 0;
    }
}

