/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.qpack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.luminis.qpack.HttpQPackDecompressionFailedException;

public class StaticTable {
    private String[] names = new String[100];
    private String[] values = new String[100];

    StaticTable() {
        Pattern empty = Pattern.compile("\\|\\s+\\|\\s+\\|\\s+\\|");
        Pattern nameOnly = Pattern.compile("\\|\\s*(\\d+)\\s*\\|\\s*([^\\|]+)\\s*\\|\\s+\\|");
        Pattern nameValue = Pattern.compile("\\|\\s*(\\d+)\\s*\\|\\s*([^\\|]+)\\s*\\|\\s*([^\\|]+)\\s*\\|");
        Pattern continuation = Pattern.compile("\\|\\s+\\|\\s*([^\\|]*)\\s*\\|\\s*([^\\|]*)\\s*\\|");
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream("statictable.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
            int lastIndex = 0;
            String line = reader.readLine();
            while (line != null) {
                if (!empty.matcher(line = line.trim()).matches()) {
                    Matcher m;
                    if (nameOnly.matcher(line).matches()) {
                        m = nameOnly.matcher(line);
                        m.matches();
                        this.names[Integer.parseInt((String)m.group((int)1).trim())] = m.group(2).trim();
                        this.values[Integer.parseInt((String)m.group((int)1).trim())] = "";
                        lastIndex = Integer.parseInt(m.group(1).trim());
                    } else if (nameValue.matcher(line).matches()) {
                        m = nameValue.matcher(line);
                        m.matches();
                        this.names[Integer.parseInt((String)m.group((int)1).trim())] = m.group(2).trim();
                        this.values[Integer.parseInt((String)m.group((int)1).trim())] = m.group(3).trim();
                        lastIndex = Integer.parseInt(m.group(1).trim());
                    } else if (continuation.matcher(line).matches()) {
                        m = continuation.matcher(line);
                        m.matches();
                        String namePart = m.group(1).trim();
                        String valuePart = m.group(2).trim();
                        if (!namePart.isBlank()) {
                            this.names[lastIndex] = this.names[lastIndex] + namePart;
                        }
                        if (!valuePart.isBlank()) {
                            this.values[lastIndex] = this.values[lastIndex] + valuePart;
                        }
                    } else {
                        throw new RuntimeException("Internal error: parsing static table definition failed.");
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Corrupt library, missing internal resource.");
        }
    }

    public String lookupName(int index) {
        String result = this.names[index];
        if (result == null) {
            throw new HttpQPackDecompressionFailedException();
        }
        return result;
    }

    public int findByNameAndValue(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        int firstMatch = -1;
        for (int i = 0; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            if (firstMatch < 0) {
                firstMatch = i;
            }
            if (!value.equals(this.values[i])) continue;
            return i;
        }
        return firstMatch;
    }

    public Map.Entry<String, String> lookupNameValue(int index) {
        if (this.names[index] != null) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(this.names[index], this.values[index]);
        }
        throw new HttpQPackDecompressionFailedException();
    }
}

