/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.qpack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.luminis.qpack.BitBuffer;
import net.luminis.qpack.NotYetImplementedException;

public class Huffman {
    private static Map<Integer, MappedSymbol> lookupTable = null;

    public Huffman() {
        if (lookupTable == null) {
            lookupTable = new HashMap<Integer, MappedSymbol>();
            HashMap<String, Integer> codeTable = new HashMap<String, Integer>();
            try {
                InputStream resourceAsStream = this.getClass().getResourceAsStream("huffmancode.txt");
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
                int index = 0;
                String line = reader.readLine();
                while (line != null) {
                    codeTable.put(this.extractBitPattern(line), index);
                    ++index;
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Corrupt library, missing internal resource.");
            }
            this.createLookupTable(codeTable, 8);
        }
    }

    public String decode(byte[] bytes) {
        StringBuffer string = new StringBuffer(bytes.length);
        BitBuffer buffer = new BitBuffer(bytes);
        while (buffer.hasRemaining()) {
            int key = buffer.peek() & 0xFF;
            MappedSymbol mappedSymbol = lookupTable.get(key);
            if (mappedSymbol != null) {
                if (mappedSymbol.isPresent()) {
                    string.append(mappedSymbol.character);
                    buffer.shift(mappedSymbol.codeLength);
                    continue;
                }
                buffer.shift(8);
                int subKey = buffer.peek() & 0xFF;
                mappedSymbol = mappedSymbol.subTable.get(subKey);
                if (mappedSymbol != null) {
                    string.append(mappedSymbol.character);
                    buffer.shift(mappedSymbol.codeLength);
                    continue;
                }
                if (subKey == 255) break;
                throw new NotYetImplementedException("3 level huffman lookup not yet supported");
            }
            throw new IllegalStateException();
        }
        return string.toString();
    }

    private void createLookupTable(Map<String, Integer> codeTable, int n) {
        codeTable.entrySet().forEach(entry -> {
            String code = (String)entry.getKey();
            if (code.length() <= n) {
                int codeValue = this.parseBits(code, code.length());
                int codeSizeInBytes = (n - 1) / 8 + 1;
                MappedSymbol mappedSymbol = new MappedSymbol((Integer)entry.getValue(), code.length());
                this.generateExtendedCodes(codeValue, code.length(), codeSizeInBytes).forEach(c -> lookupTable.put(c, mappedSymbol));
            } else if (code.length() <= 2 * n) {
                MappedSymbol mapping;
                int primaryCode = this.parseBits(code, n);
                int secondaryCode = this.parseBits(code.substring(n), code.length() - n);
                if (lookupTable.containsKey(primaryCode)) {
                    mapping = lookupTable.get(primaryCode);
                } else {
                    mapping = new MappedSymbol();
                    lookupTable.put(primaryCode, mapping);
                }
                int codeSizeInBytes = (n - 1) / 8 + 1;
                MappedSymbol mappedSymbol = new MappedSymbol((Integer)entry.getValue(), code.length() - n);
                this.generateExtendedCodes(secondaryCode, code.length() - n, codeSizeInBytes).forEach(c -> mapping.subTable.put(c, mappedSymbol));
            }
        });
    }

    private IntStream generateExtendedCodes(int codeValue, int bits, int codeSizeInBytes) {
        int baseValue = codeValue << codeSizeInBytes * 8 - bits;
        int maxAddition = (int)Math.pow(2.0, codeSizeInBytes * 8 - bits);
        return IntStream.range(0, maxAddition).map(addition -> baseValue | addition);
    }

    private int parseBits(String code, int bits) {
        return Integer.parseInt(code.substring(0, bits), 2);
    }

    private String extractBitPattern(String line) {
        int firstSpace = line.indexOf(" ");
        return line.substring(0, firstSpace).replaceAll("\\|", "");
    }

    private static class MappedSymbol {
        final char character;
        final int codeLength;
        final Map<Integer, MappedSymbol> subTable;

        public MappedSymbol(int character, int codeLength) {
            this.character = (char)character;
            this.codeLength = codeLength;
            this.subTable = null;
        }

        public MappedSymbol() {
            this.character = '\u0000';
            this.codeLength = 0;
            this.subTable = new HashMap<Integer, MappedSymbol>();
        }

        boolean isPresent() {
            return this.subTable == null;
        }
    }
}

