/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.qpack;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.luminis.qpack.Huffman;
import net.luminis.qpack.StaticTable;

public class Encoder {
    public static final Charset HTTP_HEADER_CHARSET = Charset.forName("US-ASCII");
    private final Huffman huffman;
    private final StaticTable staticTable = new StaticTable();
    private final List<Map.Entry<String, String>> dynamicTable;

    public Encoder() {
        this.huffman = new Huffman();
        this.dynamicTable = new ArrayList<Map.Entry<String, String>>();
    }

    public ByteBuffer compressHeaders(List<Map.Entry<String, String>> headers) {
        int estimatedSize = 10 + headers.stream().mapToInt(entry -> ((String)entry.getKey()).length() + ((String)entry.getValue()).length()).sum();
        ByteBuffer buffer = ByteBuffer.allocate(estimatedSize);
        this.insertHeaderBlockPrefix(buffer);
        headers.forEach(entry -> this.compressEntry((Map.Entry<String, String>)entry, buffer));
        buffer.limit(buffer.position());
        return buffer;
    }

    private void insertHeaderBlockPrefix(ByteBuffer buffer) {
        buffer.put((byte)0);
        buffer.put((byte)0);
    }

    void compressEntry(Map.Entry<String, String> entry, ByteBuffer buffer) {
        int index = this.staticTable.findByNameAndValue(entry.getKey(), entry.getValue());
        if (index >= 0) {
            if (this.staticTable.lookupNameValue(index).getValue().equals(entry.getValue())) {
                this.insertIndexedHeaderField(index, buffer);
            } else {
                this.insertLiteralHeaderFieldWithNsmeReference(index, entry.getValue(), buffer);
            }
        } else {
            this.insertLiteralHeaderFieldWithoutNameReference(entry, buffer);
        }
    }

    private void insertIndexedHeaderField(int index, ByteBuffer buffer) {
        this.insertPrefixedInteger(6, (byte)-64, index, buffer);
    }

    private void insertLiteralHeaderFieldWithNsmeReference(int index, String value, ByteBuffer buffer) {
        this.insertPrefixedInteger(4, (byte)80, index, buffer);
        byte[] valueBytes = value.getBytes(HTTP_HEADER_CHARSET);
        this.insertPrefixedInteger(7, (byte)0, valueBytes.length, buffer);
        buffer.put(valueBytes);
    }

    private void insertLiteralHeaderFieldWithoutNameReference(Map.Entry<String, String> entry, ByteBuffer buffer) {
        byte[] keyBytes = entry.getKey().getBytes(HTTP_HEADER_CHARSET);
        this.insertPrefixedInteger(3, (byte)32, keyBytes.length, buffer);
        buffer.put(keyBytes);
        byte[] valueBytes = entry.getValue().getBytes(HTTP_HEADER_CHARSET);
        this.insertPrefixedInteger(7, (byte)0, valueBytes.length, buffer);
        buffer.put(valueBytes);
    }

    void insertPrefixedInteger(int prefixLength, byte prefix, int value, ByteBuffer buffer) {
        int maxPrefix = (int)(Math.pow(2.0, prefixLength) - 1.0);
        if (value < maxPrefix) {
            buffer.put((byte)(prefix | value));
        } else {
            int remainder;
            buffer.put((byte)(prefix | maxPrefix));
            for (remainder = value - maxPrefix; remainder > 128; remainder /= 128) {
                byte next = (byte)(remainder % 128 | 0x80);
                buffer.put(next);
            }
            buffer.put((byte)remainder);
        }
    }
}

