/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.qpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.luminis.qpack.Huffman;
import net.luminis.qpack.NotYetImplementedException;
import net.luminis.qpack.StaticTable;

public class Decoder {
    private final Huffman huffman;
    private final StaticTable staticTable = new StaticTable();
    private final List<Map.Entry<String, String>> dynamicTable;

    public Decoder() {
        this.huffman = new Huffman();
        this.dynamicTable = new ArrayList<Map.Entry<String, String>>();
    }

    public void decodeEncoderStream(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 16);
        int instruction = pushbackInputStream.read();
        pushbackInputStream.unread(instruction);
        while (instruction >= 0) {
            if ((instruction & 0x80) == 128) {
                this.parseInsertWithNameReference(pushbackInputStream);
            } else if ((instruction & 0xC0) == 64) {
                this.parseInsertWithoutNameReference(pushbackInputStream);
            } else {
                throw new NotYetImplementedException("Error: unknown instruction in encoder stream: " + instruction);
            }
            instruction = pushbackInputStream.read();
            pushbackInputStream.unread(instruction);
        }
    }

    public List<Map.Entry<String, String>> decodeStream(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 16);
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        long requiredInsertCount = this.parsePrefixedInteger(8, pushbackInputStream);
        int deltaBase = (int)this.parsePrefixedInteger(7, pushbackInputStream);
        int instruction = pushbackInputStream.read();
        pushbackInputStream.unread(instruction);
        while (instruction >= 0) {
            Map.Entry<String, String> entry = null;
            if ((instruction & 0x80) == 128) {
                entry = this.parseIndexedHeaderField(pushbackInputStream);
            } else if ((instruction & 0xC0) == 64) {
                entry = this.parseLiteralHeaderFieldWithNameReference(pushbackInputStream);
            } else if ((instruction & 0xE0) == 32) {
                entry = this.parseLiteralHeaderFieldWithoutNameReference(pushbackInputStream);
            } else {
                throw new NotYetImplementedException("Error: unknown instruction: " + instruction);
            }
            if (entry != null) {
                headers.add(entry);
            }
            instruction = pushbackInputStream.read();
            pushbackInputStream.unread(instruction);
        }
        return headers;
    }

    void parseInsertWithNameReference(PushbackInputStream inputStream) throws IOException {
        int first = inputStream.read();
        inputStream.unread(first);
        int index = (int)this.parsePrefixedInteger(6, inputStream);
        boolean referStatic = (first & 0x40) == 64;
        String name = referStatic ? this.staticTable.lookupName(index) : this.lookupDynamicTable(index).getKey();
        String value = this.parseStringValue(inputStream);
        this.addToTable(name, value);
    }

    void parseInsertWithoutNameReference(PushbackInputStream inputStream) throws IOException {
        String name = this.parseStringValue(5, inputStream);
        String value = this.parseStringValue(inputStream);
        this.addToTable(name, value);
    }

    long parsePrefixedInteger(int prefixLength, InputStream input) throws IOException {
        byte next;
        int maxPrefix = (int)(Math.pow(2.0, prefixLength) - 1.0);
        int initialValue = input.read() & maxPrefix;
        if (initialValue < maxPrefix) {
            return initialValue;
        }
        long value = initialValue;
        int factor = 0;
        do {
            next = (byte)input.read();
            value += (long)((next & 0x7F) << factor);
            factor += 7;
        } while ((next & 0x80) == 128);
        return value;
    }

    Map.Entry<String, String> parseIndexedHeaderField(PushbackInputStream inputStream) throws IOException {
        byte first = (byte)inputStream.read();
        inputStream.unread(first);
        boolean inStaticTable = (first & 0x40) == 64;
        int index = (int)this.parsePrefixedInteger(6, inputStream);
        if (inStaticTable) {
            return this.staticTable.lookupNameValue(index);
        }
        return this.lookupDynamicTable(index);
    }

    Map.Entry<String, String> parseLiteralHeaderFieldWithNameReference(PushbackInputStream inputStream) throws IOException {
        byte first = (byte)inputStream.read();
        inputStream.unread(first);
        boolean inStaticTable = (first & 0x10) == 16;
        int nameIndex = (int)this.parsePrefixedInteger(4, inputStream);
        if (!inStaticTable) {
            throw new NotYetImplementedException("non static ref in parseLiteralHeaderFieldWithNameReference");
        }
        String name = inStaticTable ? this.staticTable.lookupName(nameIndex) : "<tbd>";
        String value = this.parseStringValue(inputStream);
        return new AbstractMap.SimpleEntry<String, String>(name, value);
    }

    Map.Entry<String, String> parseLiteralHeaderFieldWithoutNameReference(PushbackInputStream inputStream) throws IOException {
        String name = this.parseStringValue(3, inputStream);
        String value = this.parseStringValue(inputStream);
        return new AbstractMap.SimpleEntry<String, String>(name, value);
    }

    Map.Entry<String, String> lookupDynamicTable(int index) {
        if (index < this.dynamicTable.size()) {
            return this.dynamicTable.get(index);
        }
        return null;
    }

    private String parseStringValue(PushbackInputStream inputStream) throws IOException {
        int firstByte = inputStream.read();
        inputStream.unread(firstByte);
        boolean huffmanEncoded = (firstByte & 0x80) == 128;
        int valueLength = (int)this.parsePrefixedInteger(7, inputStream);
        byte[] rawValue = new byte[valueLength];
        inputStream.read(rawValue);
        return huffmanEncoded ? this.huffman.decode(rawValue) : new String(rawValue);
    }

    private String parseStringValue(int prefixLength, PushbackInputStream inputStream) throws IOException {
        int huffmanFlagMask;
        switch (prefixLength) {
            case 3: {
                huffmanFlagMask = 8;
                break;
            }
            case 5: {
                huffmanFlagMask = 32;
                break;
            }
            default: {
                throw new NotYetImplementedException("no huffman flag mask for prefix " + prefixLength);
            }
        }
        int firstByte = inputStream.read();
        inputStream.unread(firstByte);
        boolean huffmanEncoded = (firstByte & huffmanFlagMask) == huffmanFlagMask;
        int length = (int)this.parsePrefixedInteger(prefixLength, inputStream);
        byte[] rawBytes = new byte[length];
        inputStream.read(rawBytes);
        return huffmanEncoded ? this.huffman.decode(rawBytes) : new String(rawBytes);
    }

    private void addToTable(String name, String value) {
        this.dynamicTable.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }
}

