/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.qpack;

import java.nio.ByteBuffer;

public class BitBuffer {
    private final ByteBuffer data;
    private int head;
    private int bitsInHead;
    private int unsetInHead;

    public BitBuffer(byte[] data) {
        this.data = ByteBuffer.wrap(data);
        for (int i = 0; i < 4; ++i) {
            if (i < data.length) {
                this.head = this.head << 8 | this.data.get() & 0xFF;
                this.bitsInHead += 8;
                continue;
            }
            this.head = this.head << 8 | 0xFF;
        }
    }

    byte peek() {
        return (byte)((this.head & 0xFF000000) >> 24);
    }

    public void shift(int size) {
        if (this.unsetInHead + size >= 8) {
            this.head <<= 8 - this.unsetInHead;
            if (this.data.remaining() > 0) {
                this.head |= this.data.get() & 0xFF;
                this.bitsInHead += 8;
            } else {
                this.head |= 0xFF;
            }
            int remaining = size - (8 - this.unsetInHead);
            this.head <<= remaining;
            this.bitsInHead -= size;
            this.unsetInHead = remaining;
        } else {
            this.head <<= size;
            this.bitsInHead -= size;
            this.unsetInHead += size;
        }
    }

    public boolean hasRemaining() {
        return this.bitsInHead > 0;
    }
}

