/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.server.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import net.luminis.http3.impl.FlupkeVersion;
import net.luminis.http3.server.HttpRequestHandler;
import net.luminis.http3.server.HttpServerRequest;
import net.luminis.http3.server.HttpServerResponse;
import net.luminis.quic.run.KwikVersion;

public class FileServer
implements HttpRequestHandler {
    private final DateTimeFormatter timeFormatter;
    private final File wwwDir;

    public FileServer(File wwwDir) {
        this.wwwDir = wwwDir;
        this.timeFormatter = DateTimeFormatter.ofPattern("d/MMM/yyyy:HH:mm:ss Z").withZone(ZoneId.systemDefault());
    }

    @Override
    public void handleRequest(HttpServerRequest request, HttpServerResponse response) throws IOException {
        block16: {
            if (request.method().equals("GET")) {
                File fileInWwwDir;
                String path = request.path();
                if (path.equals("/version")) {
                    response.setStatus(200);
                    String versionLine = "Kwik version: " + KwikVersion.getVersion() + "\nFlupke version: " + FlupkeVersion.getVersion() + "\n";
                    response.getOutputStream().write(versionLine.getBytes());
                    response.getOutputStream().close();
                    this.log(request, response);
                    return;
                }
                if (path.isBlank() || path.equals("/")) {
                    path = "index.html";
                }
                if ((fileInWwwDir = this.getFileInWwwDir(path)) != null && fileInWwwDir.exists() && fileInWwwDir.isFile() && fileInWwwDir.canRead()) {
                    response.setStatus(200);
                    try (FileInputStream fileIn = new FileInputStream(fileInWwwDir);
                         OutputStream out = response.getOutputStream();){
                        fileIn.transferTo(out);
                        break block16;
                    }
                }
                response.setStatus(404);
            } else {
                response.setStatus(405);
            }
        }
        this.log(request, response);
    }

    private void log(HttpServerRequest request, HttpServerResponse response) {
        String logLine = request.clientAddress().getHostAddress() + " - - [" + this.timeFormatter.format(request.time()) + "] " + request.method() + " " + request.path() + " HTTP/3 " + response.status() + " " + response.size();
        System.out.println(logLine);
    }

    private File getFileInWwwDir(String fileName) throws IOException {
        String requestedFilePath = new File(this.wwwDir, fileName).getCanonicalPath();
        if (requestedFilePath.startsWith(this.wwwDir.getCanonicalPath())) {
            return new File(requestedFilePath);
        }
        return null;
    }
}

