/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.luminis.http3.impl.DataFrame;
import net.luminis.http3.impl.HeadersFrame;
import net.luminis.http3.impl.Http3Frame;
import net.luminis.http3.impl.RequestHeadersFrame;
import net.luminis.http3.impl.ResponseHeadersFrame;
import net.luminis.http3.impl.SettingsFrame;
import net.luminis.http3.server.DataFrameWriter;
import net.luminis.http3.server.HttpError;
import net.luminis.http3.server.HttpRequestHandler;
import net.luminis.http3.server.HttpServerRequest;
import net.luminis.http3.server.HttpServerResponse;
import net.luminis.qpack.Decoder;
import net.luminis.qpack.Encoder;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.server.ApplicationProtocolConnection;
import net.luminis.quic.server.ServerConnection;

public class Http3ServerConnection
extends ApplicationProtocolConnection
implements Consumer<QuicStream> {
    public static int MAX_HEADER_SIZE = 10240;
    public static int MAX_DATA_SIZE = 0xA00000;
    public static int MAX_FRAME_SIZE = 0xA00000;
    private static AtomicInteger threadCount = new AtomicInteger();
    private final QuicConnection quicConnection;
    private final HttpRequestHandler requestHandler;
    private InputStream controlStream;
    private int peerQpackBlockedStreams;
    private int peerQpackMaxTableCapacity;
    private InputStream clientEncoderStream;
    private final Decoder qpackDecoder;
    private final InetAddress clientAddress;

    public Http3ServerConnection(QuicConnection quicConnection, HttpRequestHandler requestHandler) {
        this.quicConnection = quicConnection;
        this.requestHandler = requestHandler;
        quicConnection.setPeerInitiatedStreamCallback(this);
        this.qpackDecoder = new Decoder();
        this.clientAddress = ((ServerConnection)quicConnection).getInitialClientAddress();
        this.startControlStream();
    }

    @Override
    public void accept(QuicStream quicStream) {
        Thread thread = new Thread(() -> this.handle(quicStream));
        thread.setName("http-" + threadCount.getAndIncrement());
        thread.start();
    }

    void handle(QuicStream quicStream) {
        if (quicStream.isUnidirectional()) {
            try {
                int streamType = quicStream.getInputStream().read();
                if (streamType == 0) {
                    this.controlStream = quicStream.getInputStream();
                    this.processControlStream(this.controlStream);
                } else if (streamType == 2) {
                    this.clientEncoderStream = quicStream.getInputStream();
                }
            }
            catch (IOException ioError) {
                this.quicConnection.close();
            }
        } else {
            InputStream requestStream = quicStream.getInputStream();
            try {
                List<Http3Frame> receivedFrames = this.parseHttp3Frames(requestStream);
                this.handleHttpRequest(receivedFrames, quicStream, new Encoder());
            }
            catch (IOException ioError) {
                this.sendHttpErrorResponse(500, "", quicStream);
            }
            catch (HttpError httpError) {
                this.sendHttpErrorResponse(httpError.getStatusCode(), httpError.getMessage(), quicStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHttpErrorResponse(int statusCode, String message, QuicStream quicStream) {
        try {
            this.sendStatus(statusCode, quicStream.getOutputStream());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                quicStream.getOutputStream().close();
            }
            catch (IOException iOException) {}
        }
    }

    List<Http3Frame> parseHttp3Frames(InputStream requestStream) throws IOException, HttpError {
        long frameType;
        ArrayList<Http3Frame> receivedFrames = new ArrayList<Http3Frame>();
        int headerSize = 0;
        int dataSize = 0;
        block4: while ((frameType = this.readFrameType(requestStream)) >= 0L) {
            int payloadLength = VariableLengthInteger.parse(requestStream);
            switch ((int)frameType) {
                case 1: {
                    if (headerSize + payloadLength > MAX_HEADER_SIZE) {
                        throw new HttpError("max frame size exceeded", 414);
                    }
                    byte[] payload = this.readExact(requestStream, payloadLength);
                    headerSize += payloadLength;
                    RequestHeadersFrame responseHeadersFrame = new RequestHeadersFrame().parsePayload(payload, this.qpackDecoder);
                    receivedFrames.add(responseHeadersFrame);
                    continue block4;
                }
                case 0: {
                    if (dataSize + payloadLength > MAX_DATA_SIZE) {
                        throw new HttpError("max frame size exceeded", 400);
                    }
                    byte[] payload = this.readExact(requestStream, payloadLength);
                    dataSize += payloadLength;
                    DataFrame dataFrame = new DataFrame().parsePayload(payload);
                    receivedFrames.add(dataFrame);
                    continue block4;
                }
            }
            if (payloadLength > MAX_FRAME_SIZE) {
                throw new HttpError("max frame size exceeded", 400);
            }
            this.readExact(requestStream, payloadLength);
        }
        return receivedFrames;
    }

    void handleHttpRequest(List<Http3Frame> receivedFrames, final QuicStream quicStream, final Encoder qpackEncoder) throws HttpError {
        RequestHeadersFrame headersFrame = (RequestHeadersFrame)receivedFrames.stream().filter(f -> f instanceof HeadersFrame).findFirst().orElseThrow(() -> new HttpError("", 400));
        HttpServerRequest request = new HttpServerRequest(headersFrame.getMethod(), headersFrame.getPath(), null, this.clientAddress);
        HttpServerResponse response = new HttpServerResponse(){
            private boolean outputStarted;
            private DataFrameWriter dataFrameWriter;

            @Override
            public OutputStream getOutputStream() {
                if (!this.outputStarted) {
                    ResponseHeadersFrame headersFrame = new ResponseHeadersFrame();
                    headersFrame.setStatus(this.status());
                    OutputStream outputStream = quicStream.getOutputStream();
                    try {
                        outputStream.write(headersFrame.toBytes(qpackEncoder));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.outputStarted = true;
                    this.dataFrameWriter = new DataFrameWriter(quicStream.getOutputStream());
                }
                return this.dataFrameWriter;
            }

            @Override
            public long size() {
                if (this.dataFrameWriter != null) {
                    return this.dataFrameWriter.getBytesWritten();
                }
                return 0L;
            }
        };
        try {
            this.requestHandler.handleRequest(request, response);
            response.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendStatus(int statusCode, OutputStream outputStream) throws IOException {
        ResponseHeadersFrame headersFrame = new ResponseHeadersFrame();
        headersFrame.setStatus(statusCode);
        outputStream.write(headersFrame.toBytes(new Encoder()));
    }

    long readFrameType(InputStream inputStream) {
        try {
            return VariableLengthInteger.parseLong(inputStream);
        }
        catch (IOException eof) {
            return -1L;
        }
    }

    void startControlStream() {
        try {
            QuicStream clientControlStream = this.quicConnection.createStream(false);
            OutputStream clientControlOutput = clientControlStream.getOutputStream();
            clientControlOutput.write(0);
            ByteBuffer settingsFrame = new SettingsFrame(0, 0).getBytes();
            clientControlStream.getOutputStream().write(settingsFrame.array(), 0, settingsFrame.limit());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processControlStream(InputStream controlStream) throws IOException {
        int frameType = VariableLengthInteger.parse(controlStream);
        if (frameType != 4) {
            throw new RuntimeException("Invalid frame on control stream");
        }
        int frameLength = VariableLengthInteger.parse(controlStream);
        byte[] payload = this.readExact(controlStream, frameLength);
        SettingsFrame settingsFrame = new SettingsFrame().parsePayload(ByteBuffer.wrap(payload));
        this.peerQpackMaxTableCapacity = settingsFrame.getQpackMaxTableCapacity();
        this.peerQpackBlockedStreams = settingsFrame.getQpackBlockedStreams();
    }

    private byte[] readExact(InputStream inputStream, int length) throws IOException {
        int read;
        byte[] data = new byte[length];
        for (int offset = 0; offset < length; offset += read) {
            read = inputStream.read(data, offset, length - offset);
            if (read > 0) {
                continue;
            }
            throw new EOFException("Stream closed by peer");
        }
        return data;
    }
}

