/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.server;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.luminis.http3.impl.DataFrame;

public class DataFrameWriter
extends OutputStream {
    private final OutputStream outputStream;
    private long bytesWritten;

    public DataFrameWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(new DataFrame(new byte[]{(byte)b}).toBytes());
        ++this.bytesWritten;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(new DataFrame(b).toBytes());
        this.bytesWritten += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer data = ByteBuffer.wrap(b);
        data.position(off);
        data.limit(len);
        this.outputStream.write(new DataFrame(data).toBytes());
        this.bytesWritten += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

