/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.sample;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.Duration;
import net.luminis.http3.Http3Client;

public class Sample {
    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length != 1) {
            System.err.println("Missing argument: server URL");
            System.exit(1);
        }
        URI serverUrl = URI.create(args[0]);
        HttpRequest request = HttpRequest.newBuilder().uri(serverUrl).header("User-Agent", "Flupke http3 library").timeout(Duration.ofSeconds(10L)).build();
        HttpClient client = Http3Client.newHttpClient();
        long start = System.currentTimeMillis();
        HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        long end = System.currentTimeMillis();
        System.out.println("Got HTTP response " + httpResponse);
        System.out.println("-   HTTP headers: " + httpResponse.headers());
        long downloadSpeed = (long)httpResponse.body().length() / (end - start);
        System.out.println("-   HTTP body (" + httpResponse.body().length() + " bytes, " + downloadSpeed + " B/s):");
        if (httpResponse.body().length() > 10240) {
            String outputFile = "http3-response.txt";
            Files.write(Paths.get(outputFile, new String[0]), httpResponse.body().getBytes(), new OpenOption[0]);
            System.out.println("Response written to file: " + outputFile);
        } else {
            System.out.println(httpResponse.body());
        }
    }
}

