/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.sample;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import net.luminis.http3.Http3Client;

public class PostExample {
    public static void main(String[] args) throws IOException, InterruptedException {
        try {
            Path inputPath;
            File inputFile;
            if (args.length != 2) {
                System.err.println("Missing argument(s). Usage: <file to post> <server url>");
                System.exit(1);
            }
            if (!(inputFile = (inputPath = Path.of(args[0], new String[0])).toFile()).exists()) {
                System.err.println("Input file '" + inputFile + "' does not exist.");
            }
            if (!inputFile.canRead()) {
                System.err.println("Input file '" + inputFile + "' is not readable.");
            }
            URI serverUrl = URI.create(args[1]);
            HttpRequest request = HttpRequest.newBuilder().uri(serverUrl).POST(HttpRequest.BodyPublishers.ofFile(inputPath)).timeout(Duration.ofSeconds(10L)).build();
            HttpClient client = Http3Client.newHttpClient();
            HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
            System.out.println("Got HTTP response " + httpResponse);
            System.out.println("-   HTTP headers: " + httpResponse.headers());
            System.out.println("-   HTTP body (" + httpResponse.body().length() + " bytes):");
            if (httpResponse.body().length() > 10240) {
                String outputFile = "http3-response.txt";
                Files.write(Paths.get(outputFile, new String[0]), httpResponse.body().getBytes(), new OpenOption[0]);
                System.out.println("Response written to file: " + outputFile);
            } else {
                System.out.println(httpResponse.body());
            }
            System.out.println("Connection statistics: " + ((Http3Client)client).getConnectionStatistics());
        }
        catch (Exception e) {
            System.out.println("PostExample: " + e);
        }
    }
}

