/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.nio.ByteBuffer;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;

public class SettingsFrame {
    private int qpackMaxTableCapacity;
    private int qpackBlockedStreams;

    public SettingsFrame(int qpackMaxTableCapacity, int qpackBlockedStreams) {
        this.qpackMaxTableCapacity = qpackMaxTableCapacity;
        this.qpackBlockedStreams = qpackBlockedStreams;
    }

    public SettingsFrame() {
    }

    public SettingsFrame parsePayload(ByteBuffer buffer) {
        while (buffer.remaining() > 0) {
            int identifier = 0;
            long value = 0L;
            try {
                identifier = (int)VariableLengthInteger.parseLong(buffer);
                value = VariableLengthInteger.parseLong(buffer);
            }
            catch (InvalidIntegerEncodingException invalidIntegerEncodingException) {
                // empty catch block
            }
            switch (identifier) {
                case 1: {
                    this.qpackMaxTableCapacity = (int)value;
                    break;
                }
                case 7: {
                    this.qpackBlockedStreams = (int)value;
                    break;
                }
            }
        }
        return this;
    }

    public ByteBuffer getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.put((byte)4);
        buffer.put((byte)0);
        buffer.put((byte)1);
        VariableLengthInteger.encode(this.qpackMaxTableCapacity, buffer);
        buffer.put((byte)7);
        VariableLengthInteger.encode(this.qpackMaxTableCapacity, buffer);
        int length = buffer.position() - 2;
        buffer.put(1, (byte)length);
        buffer.limit(buffer.position());
        return buffer;
    }

    public int getQpackMaxTableCapacity() {
        return this.qpackMaxTableCapacity;
    }

    public int getQpackBlockedStreams() {
        return this.qpackBlockedStreams;
    }
}

