/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.luminis.http3.impl.HeadersFrame;
import net.luminis.qpack.Decoder;

public class ResponseHeadersFrame
extends HeadersFrame {
    private Optional<Integer> statusCode;

    @Override
    protected void extractPseudoHeaders(Map<String, List<String>> headersMap) throws ProtocolException {
        if (headersMap.containsKey(":status")) {
            try {
                this.statusCode = Optional.of(Integer.parseInt(headersMap.get(":status").get(0)));
            }
            catch (NumberFormatException noNumber) {
                throw new ProtocolException("Invalid status code " + headersMap.get(":status"));
            }
        } else {
            this.statusCode = Optional.empty();
        }
    }

    @Override
    public ResponseHeadersFrame parsePayload(byte[] headerBlock, Decoder decoder) throws IOException {
        return (ResponseHeadersFrame)super.parsePayload(headerBlock, decoder);
    }

    @Override
    protected void addPseudoHeaders(List<Map.Entry<String, String>> qpackHeaders) {
        qpackHeaders.add(new AbstractMap.SimpleEntry<String, String>(":status", String.valueOf(this.statusCode.get())));
    }

    public int statusCode() {
        return this.statusCode.get();
    }

    public void setStatus(int statusCode) {
        this.statusCode = Optional.of(statusCode);
    }
}

