/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.luminis.http3.impl.HeadersFrame;
import net.luminis.qpack.Decoder;

public class RequestHeadersFrame
extends HeadersFrame {
    public String getMethod() {
        return (String)this.pseudoHeaders.get(":method");
    }

    public void setMethod(String method) {
        this.pseudoHeaders.put(":method", method);
    }

    public URI getUri() {
        try {
            return new URI("https://" + (String)this.pseudoHeaders.get(":authority") + (String)this.pseudoHeaders.get(":path"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException();
        }
    }

    public String getPath() {
        return (String)this.pseudoHeaders.get(":path");
    }

    public void setUri(URI uri) {
        String query;
        Object path = uri.getPath();
        if (((String)path).isBlank()) {
            path = "/";
        }
        if ((query = uri.getQuery()) != null && !query.isBlank()) {
            path = (String)path + "?" + query;
        }
        this.pseudoHeaders.put(":path", path);
        int port = uri.getPort();
        if (port <= 0) {
            port = 443;
        }
        this.pseudoHeaders.put(":authority", uri.getHost() + ":" + port);
    }

    @Override
    public RequestHeadersFrame parsePayload(byte[] headerBlock, Decoder decoder) throws IOException {
        return (RequestHeadersFrame)super.parsePayload(headerBlock, decoder);
    }

    @Override
    protected void addPseudoHeaders(List<Map.Entry<String, String>> qpackHeaders) {
        qpackHeaders.add(new AbstractMap.SimpleEntry<String, String>(":method", this.pseudoHeaders.getOrDefault(":method", "GET")));
        qpackHeaders.add(new AbstractMap.SimpleEntry<String, String>(":scheme", this.pseudoHeaders.getOrDefault(":scheme", "https")));
        qpackHeaders.add(new AbstractMap.SimpleEntry<String, String>(":path", this.pseudoHeaders.getOrDefault(":path", "/")));
        qpackHeaders.add(new AbstractMap.SimpleEntry<String, String>(":authority", (String)this.pseudoHeaders.get(":authority")));
    }

    @Override
    protected void extractPseudoHeaders(Map<String, List<String>> headersMap) throws ProtocolException {
        List.of(":method", ":scheme", ":path", ":authority").forEach(key -> this.pseudoHeaders.put(key, (String)((List)headersMap.get(key)).get(0)));
    }
}

