/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLSession;

public class Http3Response<T>
implements HttpResponse<T> {
    private final HttpRequest request;
    private final HttpHeaders headers;
    private final int statusCode;
    private T body;

    public Http3Response(HttpRequest request, int statusCode, HttpHeaders headers, CompletionStage<T> bodyCompletionStage) {
        this.request = request;
        this.headers = headers;
        this.statusCode = statusCode;
        bodyCompletionStage.thenApply(t -> {
            this.body = t;
            return this.body;
        });
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public HttpRequest request() {
        return this.request;
    }

    @Override
    public Optional<HttpResponse<T>> previousResponse() {
        return Optional.empty();
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return Optional.empty();
    }

    @Override
    public URI uri() {
        return null;
    }

    @Override
    public HttpClient.Version version() {
        return null;
    }

    public String toString() {
        return String.format("(%s %s) %d", this.request.method(), this.request.uri(), this.statusCode);
    }
}

