/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.io.IOException;
import java.net.http.HttpRequest;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.luminis.http3.Http3Client;
import net.luminis.http3.impl.Http3Connection;

public class Http3ConnectionFactory {
    private final Http3Client http3Client;
    private final Map<UdpAddress, Http3Connection> connections;

    public Http3ConnectionFactory(Http3Client http3Client) {
        this.http3Client = http3Client;
        this.connections = new ConcurrentHashMap<UdpAddress, Http3Connection>();
    }

    public Http3Connection getConnection(HttpRequest request) throws IOException {
        int port = request.uri().getPort();
        if (port <= 0) {
            port = 443;
        }
        UdpAddress address = new UdpAddress(request.uri().getHost(), port);
        try {
            return this.connections.computeIfAbsent(address, this::createConnection);
        }
        catch (RuntimeException error) {
            if (error.getCause() instanceof IOException) {
                throw (IOException)error.getCause();
            }
            throw error;
        }
    }

    private Http3Connection createConnection(UdpAddress address) {
        Http3Connection http3Connection = null;
        try {
            http3Connection = new Http3Connection(address.host, address.port, this.http3Client.isDisableCertificateCheck());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.http3Client.receiveBufferSize().isPresent()) {
            http3Connection.setReceiveBufferSize(this.http3Client.receiveBufferSize().get());
        }
        return http3Connection;
    }

    static class UdpAddress {
        String host;
        int port;

        public UdpAddress(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UdpAddress that = (UdpAddress)o;
            return this.port == that.port && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }
    }
}

