/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Flow;
import net.luminis.http3.impl.DataFrame;
import net.luminis.http3.impl.HeadersFrame;
import net.luminis.http3.impl.Http3Response;
import net.luminis.http3.impl.RequestHeadersFrame;
import net.luminis.http3.impl.ResponseHeadersFrame;
import net.luminis.http3.impl.SettingsFrame;
import net.luminis.qpack.Decoder;
import net.luminis.qpack.Encoder;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicClientConnectionImpl;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicConnectionImpl;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Statistics;
import net.luminis.quic.UnknownVersionException;
import net.luminis.quic.VariableLengthInteger;
import net.luminis.quic.Version;
import net.luminis.quic.log.SysOutLogger;

public class Http3Connection {
    public static final int DEFAULT_PORT = 443;
    private final QuicClientConnection quicConnection;
    private InputStream serverControlStream;
    private InputStream serverEncoderStream;
    private InputStream serverPushStream;
    private int serverQpackMaxTableCapacity;
    private int serverQpackBlockedStreams;
    private final Decoder qpackDecoder;
    private Statistics connectionStats;
    private boolean initialized;

    public Http3Connection(String host, int port) throws IOException {
        this(host, port, false);
    }

    public Http3Connection(String host, int port, boolean disableCertificateCheck) throws IOException {
        this(Http3Connection.createQuicConnection(host, port, disableCertificateCheck));
    }

    public Http3Connection(QuicConnection quicConnection) {
        this.quicConnection = (QuicClientConnection)quicConnection;
        quicConnection.setPeerInitiatedStreamCallback(stream -> this.doAsync(() -> this.registerServerInitiatedStream((QuicStream)stream)));
        quicConnection.setMaxAllowedBidirectionalStreams(0);
        quicConnection.setMaxAllowedUnidirectionalStreams(3);
        this.qpackDecoder = new Decoder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int connectTimeoutInMillis) throws IOException {
        Http3Connection http3Connection = this;
        synchronized (http3Connection) {
            if (!this.quicConnection.isConnected()) {
                Version quicVersion = Http3Connection.determinePreferredQuicVersion();
                String applicationProtocol = quicVersion.equals((Object)Version.QUIC_version_1) ? "h3" : Http3Connection.determineH3Version(quicVersion);
                this.quicConnection.connect(connectTimeoutInMillis, applicationProtocol, null, Collections.emptyList());
            }
            if (!this.initialized) {
                QuicStream clientControlStream = this.quicConnection.createStream(false);
                OutputStream clientControlOutput = clientControlStream.getOutputStream();
                clientControlOutput.write(0);
                ByteBuffer settingsFrame = new SettingsFrame(0, 0).getBytes();
                clientControlStream.getOutputStream().write(settingsFrame.array(), 0, settingsFrame.limit());
                this.initialized = true;
            }
        }
    }

    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        QuicStream httpStream = this.quicConnection.createStream(true);
        this.sendRequest(request, httpStream);
        Http3Response<T> http3Response = this.receiveResponse(request, responseBodyHandler, httpStream);
        return http3Response;
    }

    private static QuicConnection createQuicConnection(String host, int port, boolean disableCertificateCheck) throws SocketException, UnknownHostException {
        SysOutLogger logger = new SysOutLogger();
        logger.logInfo(true);
        logger.logPackets(true);
        logger.useRelativeTime(true);
        logger.logRecovery(true);
        logger.logCongestionControl(true);
        logger.logFlowControl(true);
        QuicClientConnectionImpl.Builder builder = QuicClientConnectionImpl.newBuilder();
        try {
            builder.uri(new URI("//" + host + ":" + port));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException();
        }
        Version quicVersion = Http3Connection.determinePreferredQuicVersion();
        builder.version(quicVersion);
        if (disableCertificateCheck) {
            builder.noServerCertificateCheck();
        }
        builder.logger(logger);
        return builder.build();
    }

    private void sendRequest(HttpRequest request, QuicStream httpStream) throws IOException {
        final OutputStream requestStream = httpStream.getOutputStream();
        RequestHeadersFrame headersFrame = new RequestHeadersFrame();
        headersFrame.setMethod(request.method());
        headersFrame.setUri(request.uri());
        headersFrame.setHeaders(request.headers());
        requestStream.write(headersFrame.toBytes(new Encoder()));
        if (request.bodyPublisher().isPresent()) {
            Flow.Subscriber<ByteBuffer> subscriber = new Flow.Subscriber<ByteBuffer>(){
                private Flow.Subscription subscription;

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    this.subscription = subscription;
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(ByteBuffer item) {
                    try {
                        DataFrame dataFrame = new DataFrame(item);
                        requestStream.write(dataFrame.toBytes());
                    }
                    catch (IOException e) {
                        this.subscription.cancel();
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                }

                @Override
                public void onComplete() {
                    try {
                        requestStream.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            request.bodyPublisher().get().subscribe(subscriber);
        }
        requestStream.close();
    }

    private <T> Http3Response<T> receiveResponse(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, QuicStream httpStream) throws IOException {
        long frameType;
        InputStream responseStream = httpStream.getInputStream();
        HttpResponse.BodySubscriber<List<ByteBuffer>> bodySubscriber = null;
        HttpResponseInfo responseInfo = null;
        ResponseState responseState = new ResponseState(httpStream);
        block4: while ((frameType = this.readFrameType(responseStream)) >= 0L) {
            int payloadLength = VariableLengthInteger.parse(responseStream);
            byte[] payload = new byte[payloadLength];
            this.readExact(responseStream, payload);
            if (frameType > 14L) continue;
            switch ((int)frameType) {
                case 1: {
                    responseState.gotHeader();
                    ResponseHeadersFrame responseHeadersFrame = new ResponseHeadersFrame().parsePayload(payload, this.qpackDecoder);
                    if (responseInfo == null) {
                        responseInfo = new HttpResponseInfo(responseHeadersFrame);
                        bodySubscriber = responseBodyHandler.apply(responseInfo);
                        bodySubscriber.onSubscribe(new Flow.Subscription(){

                            @Override
                            public void request(long n) {
                            }

                            @Override
                            public void cancel() {
                                System.out.println("BodySubscriber has cancelled the subscription.");
                            }
                        });
                        continue block4;
                    }
                    responseInfo.add(responseHeadersFrame);
                    continue block4;
                }
                case 0: {
                    responseState.gotData();
                    DataFrame dataFrame = new DataFrame().parsePayload(payload);
                    bodySubscriber.onNext(List.of(ByteBuffer.wrap(payload)));
                    continue block4;
                }
            }
            throw new RuntimeException("Unexpected frame type " + frameType);
        }
        responseState.done();
        bodySubscriber.onComplete();
        this.connectionStats = this.quicConnection.getStats();
        return new Http3Response(request, responseInfo.statusCode(), responseInfo.headers(), bodySubscriber.getBody());
    }

    long readFrameType(InputStream inputStream) throws IOException {
        try {
            return VariableLengthInteger.parseLong(inputStream);
        }
        catch (EOFException endOfStream) {
            return -1L;
        }
    }

    void registerServerInitiatedStream(QuicStream stream) {
        try {
            int streamType = stream.getInputStream().read();
            if (streamType == 0) {
                this.serverControlStream = stream.getInputStream();
                this.processControlStream();
            } else if (streamType == 1) {
                this.serverPushStream = stream.getInputStream();
            } else if (streamType == 2) {
                this.serverEncoderStream = stream.getInputStream();
            }
        }
        catch (IOException e) {
            System.err.println("ERROR while reading server initiated stream: " + e);
        }
    }

    private void processControlStream() throws IOException {
        int frameType = VariableLengthInteger.parse(this.serverControlStream);
        if (frameType != 4) {
            throw new RuntimeException("Invalid frame on control stream");
        }
        int frameLength = VariableLengthInteger.parse(this.serverControlStream);
        byte[] payload = new byte[frameLength];
        this.readExact(this.serverControlStream, payload);
        SettingsFrame settingsFrame = new SettingsFrame().parsePayload(ByteBuffer.wrap(payload));
        this.serverQpackMaxTableCapacity = settingsFrame.getQpackMaxTableCapacity();
        this.serverQpackBlockedStreams = settingsFrame.getQpackBlockedStreams();
    }

    private void readExact(InputStream inputStream, byte[] payload) throws IOException {
        int read;
        for (int offset = 0; offset < payload.length; offset += read) {
            read = inputStream.read(payload, offset, payload.length - offset);
            if (read > 0) {
                continue;
            }
            throw new EOFException("Stream closed by peer");
        }
    }

    private void doAsync(Runnable task) {
        new Thread(task).start();
    }

    private static Version determinePreferredQuicVersion() {
        String quicVersionEnvVar = System.getenv("QUIC_VERSION");
        if (quicVersionEnvVar != null) {
            if ((quicVersionEnvVar = quicVersionEnvVar.trim().toLowerCase()).equals("1")) {
                return Version.QUIC_version_1;
            }
            if (quicVersionEnvVar.startsWith("draft-")) {
                try {
                    int draftNumber = Integer.parseInt(quicVersionEnvVar.substring("draft-".length(), quicVersionEnvVar.length()));
                    if (draftNumber >= 29 && draftNumber <= 32) {
                        try {
                            return Version.parse(-16777216 + draftNumber);
                        }
                        catch (UnknownVersionException e) {
                            throw new RuntimeException();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            System.err.println("Unsupported QUIC version '" + quicVersionEnvVar + "'; should be one of: 1, draft-29, draft-30, draft-31, draft-32.");
        }
        return Version.QUIC_version_1;
    }

    private static String determineH3Version(Version quicVersion) {
        if (quicVersion.atLeast(Version.IETF_draft_29)) {
            String versionString = quicVersion.toString();
            return "h3-" + versionString.substring(versionString.length() - 2, versionString.length());
        }
        return "";
    }

    public int getServerQpackMaxTableCapacity() {
        return this.serverQpackMaxTableCapacity;
    }

    public int getServerQpackBlockedStreams() {
        return this.serverQpackBlockedStreams;
    }

    public void setReceiveBufferSize(long receiveBufferSize) {
        this.quicConnection.setDefaultStreamReceiveBufferSize(receiveBufferSize);
    }

    public Statistics getConnectionStats() {
        return this.connectionStats;
    }

    public void close() {
        ((QuicConnectionImpl)((Object)this.quicConnection)).abortConnection(null);
    }

    private static class ResponseState {
        private final QuicStream httpStream;
        ResponseStatus status = ResponseStatus.INITIAL;

        public ResponseState(QuicStream httpStream) {
            this.httpStream = httpStream;
        }

        void gotHeader() throws ProtocolException {
            if (this.status == ResponseStatus.INITIAL) {
                this.status = ResponseStatus.GOT_HEADER;
            } else {
                if (this.status == ResponseStatus.GOT_HEADER) {
                    throw new ProtocolException("Header frame is not allowed after initial header frame (quic stream " + this.httpStream.getStreamId() + ")");
                }
                if (this.status == ResponseStatus.GOT_HEADER_AND_DATA) {
                    this.status = ResponseStatus.GOT_HEADER_AND_DATA_AND_TRAILING_HEADER;
                } else if (this.status == ResponseStatus.GOT_HEADER_AND_DATA_AND_TRAILING_HEADER) {
                    throw new ProtocolException("Header frame is not allowed after trailing header frame (quic stream " + this.httpStream.getStreamId() + ")");
                }
            }
        }

        public void gotData() throws ProtocolException {
            if (this.status == ResponseStatus.INITIAL) {
                throw new ProtocolException("Missing header frame (quic stream " + this.httpStream.getStreamId() + ")");
            }
            if (this.status == ResponseStatus.GOT_HEADER) {
                this.status = ResponseStatus.GOT_HEADER_AND_DATA;
            } else if (this.status != ResponseStatus.GOT_HEADER_AND_DATA && this.status == ResponseStatus.GOT_HEADER_AND_DATA_AND_TRAILING_HEADER) {
                throw new ProtocolException("Data frame not allowed after trailing header frame (quic stream " + this.httpStream.getStreamId() + ")");
            }
        }

        public void done() throws ProtocolException {
            if (this.status == ResponseStatus.INITIAL) {
                throw new ProtocolException("Missing header frame (quic stream " + this.httpStream.getStreamId() + ")");
            }
        }

        static enum ResponseStatus {
            INITIAL,
            GOT_HEADER,
            GOT_HEADER_AND_DATA,
            GOT_HEADER_AND_DATA_AND_TRAILING_HEADER;

        }
    }

    private static class HttpResponseInfo
    implements HttpResponse.ResponseInfo {
        private HttpHeaders headers;
        private final int statusCode;

        public HttpResponseInfo(ResponseHeadersFrame headersFrame) throws ProtocolException {
            this.headers = headersFrame.headers();
            this.statusCode = headersFrame.statusCode();
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public HttpClient.Version version() {
            return null;
        }

        public void add(HeadersFrame headersFrame) {
            HashMap<String, List<String>> mergedHeadersMap = new HashMap<String, List<String>>();
            mergedHeadersMap.putAll(this.headers.map());
            mergedHeadersMap.putAll(headersFrame.headers().map());
            this.headers = HttpHeaders.of(mergedHeadersMap, (a, b) -> true);
        }
    }
}

