/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.http.HttpHeaders;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.luminis.http3.impl.Http3Frame;
import net.luminis.qpack.Decoder;
import net.luminis.qpack.Encoder;
import net.luminis.quic.VariableLengthInteger;

public abstract class HeadersFrame
extends Http3Frame {
    protected HttpHeaders httpHeaders;
    protected Map<String, String> pseudoHeaders = new HashMap<String, String>();

    public HeadersFrame() {
        this.httpHeaders = HttpHeaders.of(Collections.emptyMap(), (a, b) -> true);
    }

    public byte[] toBytes(Encoder encoder) {
        ArrayList<Map.Entry<String, String>> qpackHeaders = new ArrayList<Map.Entry<String, String>>();
        this.addPseudoHeaders(qpackHeaders);
        this.addHeaders(qpackHeaders);
        ByteBuffer compressedHeaders = encoder.compressHeaders(qpackHeaders);
        compressedHeaders.flip();
        ByteBuffer payloadLength = ByteBuffer.allocate(4);
        VariableLengthInteger.encode(compressedHeaders.limit(), payloadLength);
        payloadLength.flip();
        byte[] data = new byte[1 + payloadLength.limit() + compressedHeaders.limit()];
        data[0] = 1;
        payloadLength.get(data, 1, payloadLength.limit());
        compressedHeaders.get(data, 1 + payloadLength.limit(), compressedHeaders.limit());
        return data;
    }

    public HeadersFrame parsePayload(byte[] headerBlock, Decoder decoder) throws IOException {
        List<Map.Entry<String, String>> headersList = decoder.decodeStream(new ByteArrayInputStream(headerBlock));
        Map<String, List<String>> headersMap = headersList.stream().collect(Collectors.toMap(Map.Entry::getKey, this::mapValue));
        this.extractPseudoHeaders(headersMap);
        this.httpHeaders = HttpHeaders.of(headersMap, (key, value) -> !key.startsWith(":"));
        return this;
    }

    protected abstract void extractPseudoHeaders(Map<String, List<String>> var1) throws ProtocolException;

    public void setHeaders(HttpHeaders headers) {
        this.httpHeaders = headers;
    }

    public HttpHeaders headers() {
        return this.httpHeaders;
    }

    protected abstract void addPseudoHeaders(List<Map.Entry<String, String>> var1);

    private void addHeaders(List<Map.Entry<String, String>> qpackHeaders) {
        this.httpHeaders.map().entrySet().forEach(entry -> {
            String value = ((List)entry.getValue()).stream().collect(Collectors.joining(","));
            qpackHeaders.add(new AbstractMap.SimpleEntry<String, String>(((String)entry.getKey()).toLowerCase(), value));
        });
    }

    private List<String> mapValue(Map.Entry<String, String> entry) {
        return List.of(entry.getValue());
    }
}

