/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3.impl;

import java.nio.ByteBuffer;
import net.luminis.http3.impl.Http3Frame;
import net.luminis.quic.InvalidIntegerEncodingException;
import net.luminis.quic.VariableLengthInteger;

public class DataFrame
extends Http3Frame {
    private ByteBuffer payload;

    public DataFrame() {
        this.payload = ByteBuffer.allocate(0);
    }

    public DataFrame(byte[] payload) {
        this.payload = ByteBuffer.wrap(payload);
    }

    public DataFrame(ByteBuffer payload) {
        this.payload = payload;
    }

    public byte[] toBytes() {
        int payloadLength = this.payload.limit() - this.payload.position();
        ByteBuffer lengthBuffer = ByteBuffer.allocate(8);
        int varIntLength = VariableLengthInteger.encode(payloadLength, lengthBuffer);
        int dataLength = 1 + varIntLength + payloadLength;
        byte[] data = new byte[dataLength];
        data[0] = 0;
        lengthBuffer.flip();
        lengthBuffer.get(data, 1, varIntLength);
        this.payload.get(data, 1 + varIntLength, payloadLength);
        return data;
    }

    public DataFrame parsePayload(byte[] payload) {
        this.payload = ByteBuffer.wrap(payload);
        return this;
    }

    public DataFrame parse(byte[] data) throws InvalidIntegerEncodingException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        if (buffer.get() != 0) {
            throw new IllegalArgumentException("Type mismatch: not a data frame");
        }
        int payloadLength = VariableLengthInteger.parse(buffer);
        if (buffer.remaining() <= payloadLength) {
            this.payload = buffer.slice();
        }
        return this;
    }

    public byte[] getPayload() {
        int payloadLength = this.payload.limit() - this.payload.position();
        if (payloadLength == this.payload.array().length) {
            return this.payload.array();
        }
        byte[] payloadBytes = new byte[payloadLength];
        this.payload.mark();
        this.payload.get(payloadBytes);
        this.payload.reset();
        return payloadBytes;
    }

    public String toString() {
        int payloadLength = this.payload.limit() - this.payload.position();
        return "DataFrame[" + payloadLength + "]";
    }
}

