/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3;

import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import net.luminis.http3.Http3Client;

public class Http3ClientBuilder
implements HttpClient.Builder {
    private Duration connectTimeout;
    private Long receiveBufferSize;
    private boolean disableCertificateCheck;

    public HttpClient.Builder receiveBufferSize(long bufferSize) {
        this.receiveBufferSize = bufferSize;
        return this;
    }

    @Override
    public HttpClient.Builder cookieHandler(CookieHandler cookieHandler) {
        return this;
    }

    @Override
    public HttpClient.Builder connectTimeout(Duration duration) {
        this.connectTimeout = duration;
        return this;
    }

    @Override
    public HttpClient.Builder sslContext(SSLContext sslContext) {
        return this;
    }

    @Override
    public HttpClient.Builder sslParameters(SSLParameters sslParameters) {
        return this;
    }

    @Override
    public HttpClient.Builder executor(Executor executor) {
        return this;
    }

    @Override
    public HttpClient.Builder followRedirects(HttpClient.Redirect policy) {
        if (policy != HttpClient.Redirect.NEVER) {
            throw new IllegalArgumentException("Follow redirects not supported");
        }
        return this;
    }

    @Override
    public HttpClient.Builder version(HttpClient.Version version) {
        return this;
    }

    @Override
    public HttpClient.Builder priority(int priority) {
        return this;
    }

    @Override
    public HttpClient.Builder proxy(ProxySelector proxySelector) {
        return this;
    }

    @Override
    public HttpClient.Builder authenticator(Authenticator authenticator) {
        return this;
    }

    public HttpClient.Builder disableCertificateCheck() {
        this.disableCertificateCheck = true;
        return this;
    }

    @Override
    public HttpClient build() {
        return new Http3Client(this.connectTimeout, this.receiveBufferSize, this.disableCertificateCheck);
    }
}

