/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.http3;

import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import net.luminis.http3.Http3ClientBuilder;
import net.luminis.http3.impl.Http3Connection;
import net.luminis.http3.impl.Http3ConnectionFactory;
import net.luminis.quic.Statistics;
import net.luminis.quic.concurrent.DaemonThreadFactory;

public class Http3Client
extends HttpClient {
    protected static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private final Duration connectTimeout;
    private final Long receiveBufferSize;
    private final boolean disableCertificateCheck;
    private Http3Connection http3Connection;
    protected Http3ConnectionFactory http3ConnectionFactory;
    private final ExecutorService executorService;

    Http3Client(Duration connectTimeout, Long receiveBufferSize, boolean disableCertificateCheck) {
        this.connectTimeout = connectTimeout;
        this.receiveBufferSize = receiveBufferSize;
        this.disableCertificateCheck = disableCertificateCheck;
        this.http3ConnectionFactory = new Http3ConnectionFactory(this);
        this.executorService = Executors.newCachedThreadPool(new DaemonThreadFactory("http3"));
    }

    public static HttpClient newHttpClient() {
        return new Http3ClientBuilder().build();
    }

    public static HttpClient.Builder newBuilder() {
        return new Http3ClientBuilder();
    }

    public Optional<Long> receiveBufferSize() {
        return Optional.ofNullable(this.receiveBufferSize);
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return Optional.empty();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return HttpClient.Redirect.NEVER;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.empty();
    }

    @Override
    public SSLContext sslContext() {
        return null;
    }

    @Override
    public SSLParameters sslParameters() {
        return null;
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return Optional.empty();
    }

    @Override
    public HttpClient.Version version() {
        return null;
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.empty();
    }

    public boolean isDisableCertificateCheck() {
        return this.disableCertificateCheck;
    }

    public <T> HttpResponse<T> sendWithNewConnection(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        long start = System.currentTimeMillis();
        this.http3Connection = new Http3Connection(request.uri().getHost(), request.uri().getPort(), this.disableCertificateCheck);
        long end = System.currentTimeMillis();
        System.out.println(" =================== CREATING CONNECTION:  " + (end - start));
        start = System.currentTimeMillis();
        HttpResponse<T> result = this.send(this.http3Connection, request, responseBodyHandler);
        end = System.currentTimeMillis();
        System.out.println(" =================== SENDING:  " + (end - start));
        return result;
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        this.http3Connection = this.http3ConnectionFactory.getConnection(request);
        return this.send(this.http3Connection, request, responseBodyHandler);
    }

    public <T> HttpResponse<T> send(Http3Connection http3Connection, HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        http3Connection.connect((int)this.connectTimeout().orElse(DEFAULT_CONNECT_TIMEOUT).toMillis());
        return http3Connection.send(request, responseBodyHandler);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        CompletableFuture future = new CompletableFuture();
        this.executorService.submit(() -> {
            try {
                future.complete(this.send(request, responseBodyHandler));
            }
            catch (IOException ex) {
                future.completeExceptionally(ex);
            }
            catch (RuntimeException ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        throw new UnsupportedOperationException("server push is not (yet) supported");
    }

    public Statistics getConnectionStatistics() {
        if (this.http3Connection != null) {
            return this.http3Connection.getConnectionStats();
        }
        return null;
    }

    public void closeConnection() {
        if (this.http3Connection != null) {
            this.http3Connection.close();
        }
    }
}

