/*
 * Decompiled with CFR 0.152.
 */
package dev.jora.quicloadgenerator.picocli.subcommands;

import dev.jora.quicloadgenerator.controllers.RateLimiterService;
import dev.jora.quicloadgenerator.controllers.RateLimiterServiceImpl;
import dev.jora.quicloadgenerator.models.ScenarioOptions;
import dev.jora.quicloadgenerator.scenarios.ProtocolType;
import dev.jora.quicloadgenerator.scenarios.ScenarioFactory;
import dev.jora.quicloadgenerator.scenarios.ScenarioType;
import dev.jora.quicloadgenerator.scenarios.protocol.BaseProtocolWrapper;
import java.io.File;
import java.net.URI;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Start execution process"})
public class RunCommand
implements Runnable {
    @CommandLine.Option(names={"--rps", "-r"}, required=true, description={"requests per second"}, paramLabel="RATE")
    Integer rps;
    @CommandLine.Option(names={"-s", "--seconds"}, description={"Experiment duration in seconds"}, paramLabel="SECONDS")
    Integer seconds;
    @CommandLine.Option(names={"-c", "--count"}, description={"Total requests count in experiment"}, paramLabel="REQUESTS_COUNT")
    Integer requestsCount;
    @CommandLine.Option(names={"-k", "--insecure"}, description={"Disable certificate verification"})
    boolean disableCertificateVerification;
    @CommandLine.Option(names={"-st", "--scenario-type"}, defaultValue="GET", description={"Scenario type"})
    ScenarioType scenarioType;
    @CommandLine.Option(names={"-pt", "--protocol-type"}, defaultValue="QUIC", description={"Protocol type"})
    ProtocolType protocolType;
    @CommandLine.Option(names={"-o", "--out"}, defaultValue="./tmp.csv", description={"output for CSV results"})
    File outFile;
    @CommandLine.Parameters
    URI serverUri;

    @Override
    public void run() {
        if (this.seconds == null == (this.requestsCount == null)) {
            System.out.println("One of SECONDS or REQUESTS_COUNT should be defined to start evaluation!");
            return;
        }
        RateLimiterService service = RateLimiterServiceImpl.instance(this.rps);
        if (service == null) {
            return;
        }
        ScenarioOptions options = new ScenarioOptions();
        options.setServerUri(this.serverUri);
        options.setDisableCertificateVerification(this.disableCertificateVerification);
        BaseProtocolWrapper callable = ScenarioFactory.build(this.protocolType, this.scenarioType, options);
        if (callable == null) {
            System.out.println("Error! Unknown scenario/protocol combination: " + this.scenarioType + " / " + this.protocolType);
            return;
        }
        try {
            if (this.seconds == null) {
                service.runByCount(callable, this.requestsCount, this.outFile);
            } else {
                service.runBySeconds(callable, this.seconds, this.outFile);
            }
            System.out.println("Started successfully!");
        }
        catch (Exception err) {
            System.out.println("Error");
            err.printStackTrace();
        }
    }
}

