/*
 * Decompiled with CFR 0.152.
 */
package dev.jora.quicloadgenerator.models;

import java.net.http.HttpResponse;
import java.time.Instant;

public class CommonResponse {
    private String errorMessage;
    private long durationMs;
    private long bodySize;
    private long speed;
    private Instant startTime;
    private Instant endTime;
    HttpResponse<?> response;

    public String[] toCsvLine() {
        return new String[]{this.errorMessage, String.valueOf(this.durationMs), String.valueOf(this.bodySize), String.valueOf(this.speed), this.startTime.toString(), this.endTime.toString(), String.valueOf(this.response.statusCode()), this.response.request().method()};
    }

    CommonResponse(String errorMessage, long durationMs, long bodySize, long speed, Instant startTime, Instant endTime, HttpResponse<?> response) {
        this.errorMessage = errorMessage;
        this.durationMs = durationMs;
        this.bodySize = bodySize;
        this.speed = speed;
        this.startTime = startTime;
        this.endTime = endTime;
        this.response = response;
    }

    public static CommonResponseBuilder builder() {
        return new CommonResponseBuilder();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public long getSpeed() {
        return this.speed;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public HttpResponse<?> getResponse() {
        return this.response;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }

    public void setBodySize(long bodySize) {
        this.bodySize = bodySize;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    public void setStartTime(Instant startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    public void setResponse(HttpResponse<?> response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonResponse)) {
            return false;
        }
        CommonResponse other = (CommonResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDurationMs() != other.getDurationMs()) {
            return false;
        }
        if (this.getBodySize() != other.getBodySize()) {
            return false;
        }
        if (this.getSpeed() != other.getSpeed()) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        Instant this$startTime = this.getStartTime();
        Instant other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Instant this$endTime = this.getEndTime();
        Instant other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        HttpResponse<?> this$response = this.getResponse();
        HttpResponse<?> other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !this$response.equals(other$response));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $durationMs = this.getDurationMs();
        result = result * 59 + (int)($durationMs >>> 32 ^ $durationMs);
        long $bodySize = this.getBodySize();
        result = result * 59 + (int)($bodySize >>> 32 ^ $bodySize);
        long $speed = this.getSpeed();
        result = result * 59 + (int)($speed >>> 32 ^ $speed);
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        Instant $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Instant $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        HttpResponse<?> $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        return result;
    }

    public String toString() {
        return "CommonResponse(errorMessage=" + this.getErrorMessage() + ", durationMs=" + this.getDurationMs() + ", bodySize=" + this.getBodySize() + ", speed=" + this.getSpeed() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", response=" + this.getResponse() + ")";
    }

    public static class CommonResponseBuilder {
        private String errorMessage;
        private long durationMs;
        private long bodySize;
        private long speed;
        private Instant startTime;
        private Instant endTime;
        private HttpResponse<?> response;

        CommonResponseBuilder() {
        }

        public CommonResponseBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public CommonResponseBuilder durationMs(long durationMs) {
            this.durationMs = durationMs;
            return this;
        }

        public CommonResponseBuilder bodySize(long bodySize) {
            this.bodySize = bodySize;
            return this;
        }

        public CommonResponseBuilder speed(long speed) {
            this.speed = speed;
            return this;
        }

        public CommonResponseBuilder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public CommonResponseBuilder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public CommonResponseBuilder response(HttpResponse<?> response) {
            this.response = response;
            return this;
        }

        public CommonResponse build() {
            return new CommonResponse(this.errorMessage, this.durationMs, this.bodySize, this.speed, this.startTime, this.endTime, this.response);
        }

        public String toString() {
            return "CommonResponse.CommonResponseBuilder(errorMessage=" + this.errorMessage + ", durationMs=" + this.durationMs + ", bodySize=" + this.bodySize + ", speed=" + this.speed + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", response=" + this.response + ")";
        }
    }
}

