/*
 * Decompiled with CFR 0.152.
 */
package dev.jora.quicloadgenerator.controllers;

import com.opencsv.CSVWriter;
import dev.jora.quicloadgenerator.controllers.RateLimiterService;
import dev.jora.quicloadgenerator.models.CommonResponse;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class RateLimiterServiceImpl
implements RateLimiterService {
    private final Bucket bucket;
    private final ExecutorService executor;
    private final CompletionService<CommonResponse> service;
    private final ExecutorService ioExecutor;
    private final CompletionService<String[]> ioService;
    private final int rps;

    private RateLimiterServiceImpl(int rps) {
        this.bucket = this.createBucket(rps);
        this.rps = rps;
        this.executor = Executors.newFixedThreadPool(rps);
        this.service = new ExecutorCompletionService<CommonResponse>(this.executor);
        this.ioExecutor = Executors.newSingleThreadExecutor();
        this.ioService = new ExecutorCompletionService<String[]>(this.ioExecutor);
    }

    public static RateLimiterService instance(int rps) {
        if (rps < 0 || rps > 1000) {
            System.out.println("Invalid RPS value! Stopping...");
            return null;
        }
        return new RateLimiterServiceImpl(rps);
    }

    public Bucket createBucket(int rps) {
        Bandwidth limit = Bandwidth.simple(rps, Duration.ofSeconds(1L));
        return ((LocalBucketBuilder)Bucket4j.builder().addLimit(limit)).build();
    }

    @Override
    public void runByCount(Callable<CommonResponse> callable, int count, File outFile) throws InterruptedException {
        Thread waiter = new Thread(() -> {
            System.out.println("waiter started! " + Instant.now().toString());
            try {
                int counter = 0;
                while (!this.executor.isTerminated() && counter++ < count) {
                    System.out.println("here" + Instant.now().toString());
                    Future<CommonResponse> future = this.service.take();
                    Object[] resultStrings = future.get().toCsvLine();
                    System.out.println(Arrays.toString(resultStrings));
                    this.ioService.submit(() -> RateLimiterServiceImpl.lambda$runByCount$0((String[])resultStrings));
                }
            }
            catch (InterruptedException | ExecutionException err) {
                err.printStackTrace();
            }
        });
        Thread ioWaiter = new Thread(() -> {
            try {
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    fos.write("".getBytes());
                }
                try (CSVWriter csvWriter = new CSVWriter(new FileWriter(outFile, true));){
                    int counter = 0;
                    while (!this.ioExecutor.isTerminated() && counter++ < count) {
                        Future<String[]> future = this.ioService.take();
                        csvWriter.writeNext(future.get());
                        csvWriter.flush();
                    }
                }
            }
            catch (IOException | InterruptedException | ExecutionException err) {
                err.printStackTrace();
            }
        });
        waiter.start();
        ioWaiter.start();
        for (int i = 0; i < count; ++i) {
            this.bucket.asScheduler().consume(1L);
            this.service.submit(callable);
        }
        this.executor.shutdown();
        waiter.join();
        this.ioExecutor.shutdown();
        ioWaiter.join();
    }

    @Override
    public void runBySeconds(Callable<CommonResponse> callable, int seconds, File outFile) throws InterruptedException {
        int count = seconds * this.rps;
        this.runByCount(callable, count, outFile);
    }

    private static /* synthetic */ String[] lambda$runByCount$0(String[] resultStrings) throws Exception {
        return resultStrings;
    }
}

