/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc.interceptor.impl.period;

import dev.jfr4jdbc.interceptor.Interceptor;
import dev.jfr4jdbc.interceptor.StatementContext;
import dev.jfr4jdbc.interceptor.impl.period.PeriodStatementEvent;
import dev.jfr4jdbc.internal.ConnectionInfo;

public class PeriodStatementInterceptor
implements Interceptor<StatementContext> {
    private PeriodStatementEvent event;

    @Override
    public void preInvoke(StatementContext context) {
        this.event = new PeriodStatementEvent();
        this.event.begin();
    }

    @Override
    public void postInvoke(StatementContext context) {
        this.event.end();
        if (this.event.shouldCommit()) {
            ConnectionInfo conInfo = context.connectionInfo;
            this.event.dataSourceLabel = conInfo.dataSourceLabel;
            this.event.connectionId = conInfo.conId;
            this.event.wrappedConnectionId = conInfo.wrappedConId;
            this.event.operationId = context.operationInfo.id;
            this.event.inquiry = context.inquiry;
            this.event.isPrepared = context.isPrepared;
            this.event.inquiryParameter = context.getInquiryParameter();
            this.event.isStatementPoolable = context.isStatementPoolable();
            this.event.isStatementClosed = context.isStatementClosed();
            this.event.isAutoCommitted = context.isAutoCommitted();
            if (context.getException() != null) {
                this.event.exception = context.getException().getClass();
                this.event.exceptionMessage = context.getException().getMessage();
            }
            this.event.commit();
        }
    }
}

