/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc.interceptor.impl.period;

import dev.jfr4jdbc.interceptor.Interceptor;
import dev.jfr4jdbc.interceptor.ResultSetContext;
import dev.jfr4jdbc.interceptor.impl.period.PeriodResultSetEvent;
import dev.jfr4jdbc.internal.ConnectionInfo;

public class PeriodResultSetInterceptor
implements Interceptor<ResultSetContext> {
    private PeriodResultSetEvent event;

    @Override
    public void preInvoke(ResultSetContext context) {
        this.event = new PeriodResultSetEvent();
        this.event.begin();
    }

    @Override
    public void postInvoke(ResultSetContext context) {
        this.event.end();
        if (this.event.shouldCommit()) {
            ConnectionInfo conInfo = context.connectionInfo;
            this.event.dataSourceLabel = conInfo.dataSourceLabel;
            this.event.connectionId = conInfo.conId;
            this.event.wrappedConnectionId = conInfo.wrappedConId;
            this.event.operationId = context.operationInfo.id;
            this.event.result = context.isResult();
            this.event.rowNo = context.getRowNo();
            if (context.getException() != null) {
                this.event.exception = context.getException().getClass();
                this.event.exceptionMessage = context.getException().getMessage();
            }
            this.event.commit();
        }
    }
}

