/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc.interceptor.impl.period;

import dev.jfr4jdbc.interceptor.DataSourceContext;
import dev.jfr4jdbc.interceptor.Interceptor;
import dev.jfr4jdbc.interceptor.impl.period.PeriodDataSourceEvent;
import dev.jfr4jdbc.internal.ConnectionInfo;

public class PeriodDataSourceInterceptor
implements Interceptor<DataSourceContext> {
    private PeriodDataSourceEvent event;

    @Override
    public void preInvoke(DataSourceContext context) {
        this.event = new PeriodDataSourceEvent();
        this.event.begin();
    }

    @Override
    public void postInvoke(DataSourceContext context) {
        this.event.end();
        if (this.event.shouldCommit()) {
            ConnectionInfo conInfo = context.getConnectionInfo();
            this.event.dataSourceLabel = conInfo.dataSourceLabel;
            this.event.connectionId = conInfo.conId;
            this.event.wrappedConnectionId = conInfo.wrappedConId;
            this.event.username = context.getUsername();
            this.event.password = context.getPassword();
            if (context.getException() != null) {
                this.event.exception = context.getException().getClass();
                this.event.exceptionMessage = context.getException().getMessage();
            }
            this.event.commit();
        }
    }
}

