/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc.interceptor.impl.period;

import dev.jfr4jdbc.interceptor.CommitContext;
import dev.jfr4jdbc.interceptor.Interceptor;
import dev.jfr4jdbc.interceptor.impl.period.PeriodCommitEvent;
import dev.jfr4jdbc.internal.ConnectionInfo;

public class PeriodCommitInterceptor
implements Interceptor<CommitContext> {
    private PeriodCommitEvent event;

    @Override
    public void preInvoke(CommitContext context) {
        this.event = new PeriodCommitEvent();
        this.event.begin();
    }

    @Override
    public void postInvoke(CommitContext context) {
        this.event.end();
        if (this.event.shouldCommit()) {
            ConnectionInfo conInfo = context.connectionInfo;
            this.event.dataSourceLabel = conInfo.dataSourceLabel;
            this.event.connectionId = conInfo.conId;
            this.event.wrappedConnectionId = conInfo.wrappedConId;
            this.event.operationId = context.operationInfo.id;
            if (context.getException() != null) {
                this.event.exception = context.getException().getClass();
                this.event.exceptionMessage = context.getException().getMessage();
            }
            this.event.commit();
        }
    }
}

