/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc.interceptor.impl.legacy;

import dev.jfr4jdbc.EventFactory;
import dev.jfr4jdbc.event.ConnectEvent;
import dev.jfr4jdbc.interceptor.DataSourceContext;
import dev.jfr4jdbc.interceptor.Interceptor;

public class LegacyDataSourceInterceptor
implements Interceptor<DataSourceContext> {
    private final EventFactory factory;
    private ConnectEvent event;

    public LegacyDataSourceInterceptor(EventFactory factory) {
        this.factory = factory;
    }

    @Override
    public void preInvoke(DataSourceContext context) {
        this.event = this.factory.createConnectEvent();
        this.event.begin();
    }

    @Override
    public void postInvoke(DataSourceContext context) {
        this.event.end();
        if (this.event.shouldCommit()) {
            if (context.getConnection() != null) {
                this.event.setConnectionClass(context.getConnection().getClass());
            }
            this.event.setDataSourceId(context.dataSourceId);
            this.event.setDataSourceClass(context.dataSource.getClass());
            this.event.setUserName(context.getUsername());
            this.event.setPassword(context.getPassword());
            this.event.setConnectionId(context.getConnectionInfo().conId);
            this.event.commit();
        }
    }
}

