/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc.interceptor;

import dev.jfr4jdbc.interceptor.InterceptorFactory;
import dev.jfr4jdbc.interceptor.impl.instant.InstantInterceptorFactory;
import dev.jfr4jdbc.interceptor.impl.legacy.LegacyInterceptorFactory;
import dev.jfr4jdbc.interceptor.impl.period.PeriodInterceptorFactory;

public class InterceptorManager {
    private static final String DEFAULT_INTERCEPTOR_FACTORY_ENV_NAME = "jfr-interceptor-factory";
    private static InterceptorFactory defaultInterceptorFactory;

    public static InterceptorFactory getDefaultInterceptorFactory() {
        return defaultInterceptorFactory;
    }

    public static InterceptorFactory getInterceptorFactory(String defaultInterceptorParameter) {
        if (defaultInterceptorParameter != null) {
            if (defaultInterceptorParameter.toLowerCase().equals("instant")) {
                return new InstantInterceptorFactory();
            }
            if (defaultInterceptorParameter.toLowerCase().equals("legacy")) {
                return new LegacyInterceptorFactory();
            }
        }
        return new PeriodInterceptorFactory();
    }

    static {
        String defaultInterceptorParameter = System.getProperty(DEFAULT_INTERCEPTOR_FACTORY_ENV_NAME);
        defaultInterceptorFactory = InterceptorManager.getInterceptorFactory(defaultInterceptorParameter);
    }
}

