/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc;

import dev.jfr4jdbc.Jfr4JdbcRuntimeException;
import dev.jfr4jdbc.JfrConnection;
import dev.jfr4jdbc.interceptor.DriverContext;
import dev.jfr4jdbc.interceptor.Interceptor;
import dev.jfr4jdbc.interceptor.InterceptorFactory;
import dev.jfr4jdbc.interceptor.InterceptorManager;
import dev.jfr4jdbc.internal.ConnectionInfo;
import dev.jfr4jdbc.internal.ResourceMonitor;
import dev.jfr4jdbc.internal.ResourceMonitorKind;
import dev.jfr4jdbc.internal.ResourceMonitorManager;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class JfrServiceLoadedDriver
implements Driver {
    private static final String JFR4JDBC_URL_PREFIX = "jdbc:jfr";
    private static final int JFR4JDBC_URL_PREFIX_LENGTH = "jdbc:jfr".length();
    private static final String INTERCEPTOR_FACTORY_ATTRIBUTE_NAME = "jfr-interceptor-factory";
    private final Map<String, AtomicInteger> counterForUrl = new HashMap<String, AtomicInteger>(1);
    private final Map<String, Driver> driverCache = new HashMap<String, Driver>(1);

    private static final String getDelegateUrl(String url) {
        String delegateUrl = "jdbc" + url.substring(JFR4JDBC_URL_PREFIX_LENGTH);
        return delegateUrl;
    }

    private InterceptorFactory loadInterceptorFactory(String url, Properties info) {
        return InterceptorManager.getDefaultInterceptorFactory();
    }

    private Driver getDelegatedDriver(String url) throws SQLException {
        Driver driver = this.driverCache.get(url);
        if (driver == null) {
            driver = DriverManager.getDriver(url);
            this.driverCache.put(url, driver);
        }
        return driver;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        Driver delegateDriver;
        if (!url.startsWith(JFR4JDBC_URL_PREFIX)) {
            return false;
        }
        String delegeteJdbcDriverUrl = JfrServiceLoadedDriver.getDelegateUrl(url);
        try {
            delegateDriver = this.getDelegatedDriver(delegeteJdbcDriverUrl);
        }
        catch (SQLException e) {
            delegateDriver = null;
        }
        return delegateDriver != null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!url.startsWith(JFR4JDBC_URL_PREFIX)) {
            return null;
        }
        String delegeteUrl = JfrServiceLoadedDriver.getDelegateUrl(url);
        Driver delegateDriver = this.getDelegatedDriver(delegeteUrl);
        if (delegateDriver == null) {
            return null;
        }
        int connectionId = this.counterForUrl.computeIfAbsent(delegeteUrl, u -> new AtomicInteger(1)).getAndIncrement();
        DriverContext context = new DriverContext(delegateDriver, delegeteUrl, connectionId);
        Map<String, String> urlAttributes = this.getUrlAttribute(delegeteUrl);
        InterceptorFactory interceptorFactory = null;
        interceptorFactory = urlAttributes.containsKey(INTERCEPTOR_FACTORY_ATTRIBUTE_NAME) ? InterceptorManager.getInterceptorFactory(urlAttributes.get(INTERCEPTOR_FACTORY_ATTRIBUTE_NAME)) : InterceptorManager.getDefaultInterceptorFactory();
        Interceptor<DriverContext> interceptor = interceptorFactory.createDriverInterceptor();
        ResourceMonitorManager manager = ResourceMonitorManager.getInstance(ResourceMonitorKind.Connection);
        ResourceMonitor monitor = manager.getMonitor(delegeteUrl);
        if (monitor == null) {
            monitor = manager.createConnectionMonitor(delegateDriver, delegeteUrl, interceptorFactory);
            manager.addMonitor(monitor);
        }
        Connection delegatedCon = null;
        try {
            monitor.waitAssigningResource();
            interceptor.preInvoke(context);
            delegatedCon = delegateDriver.connect(delegeteUrl, info);
            if (delegatedCon == null) {
                throw new SQLException("Invalid driver url: " + url);
            }
            context.setConnection(delegatedCon, 0);
        }
        catch (RuntimeException | SQLException e) {
            context.setException(e);
            throw e;
        }
        finally {
            interceptor.postInvoke(context);
            monitor.assignedResource();
        }
        return new JfrConnection(delegatedCon, this.loadInterceptorFactory(url, info), monitor, new ConnectionInfo(delegeteUrl, connectionId, 0));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver driver = this.getDelegatedDriver(url);
        if (driver == null) {
            throw new Jfr4JdbcRuntimeException("No delegate Driver");
        }
        return driver.getPropertyInfo(JfrServiceLoadedDriver.getDelegateUrl(url), info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Jfr4Jdbc doesn't support");
    }

    protected Map<String, String> getUrlAttribute(String url) {
        String[] splitUrl = url.split(";");
        HashMap<String, String> urlAttributeMap = new HashMap<String, String>(splitUrl.length - 1);
        for (String parameter : splitUrl) {
            String key;
            if (!parameter.contains("=")) continue;
            String[] splitParameter = parameter.split("=");
            if (splitParameter.length == 2) {
                key = splitParameter[0].toLowerCase();
                String value = splitParameter[1];
                urlAttributeMap.put(key, value);
                continue;
            }
            if (splitParameter.length != 1) continue;
            key = splitParameter[0].toLowerCase();
            urlAttributeMap.put(key, "");
        }
        return urlAttributeMap;
    }

    static {
        try {
            DriverManager.registerDriver(new JfrServiceLoadedDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register Jfr4Jdbc.", e);
        }
    }
}

