/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc;

import dev.jfr4jdbc.JfrCallableStatement;
import dev.jfr4jdbc.JfrPreparedStatement;
import dev.jfr4jdbc.JfrStatement;
import dev.jfr4jdbc.interceptor.CloseContext;
import dev.jfr4jdbc.interceptor.CommitContext;
import dev.jfr4jdbc.interceptor.Interceptor;
import dev.jfr4jdbc.interceptor.InterceptorFactory;
import dev.jfr4jdbc.interceptor.InterceptorManager;
import dev.jfr4jdbc.interceptor.RollbackContext;
import dev.jfr4jdbc.internal.ConnectionInfo;
import dev.jfr4jdbc.internal.OperationInfo;
import dev.jfr4jdbc.internal.ResourceMonitor;
import dev.jfr4jdbc.internal.ResourceMonitorKind;
import dev.jfr4jdbc.internal.ResourceMonitorManager;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class JfrConnection42
implements Connection {
    protected final Connection connection;
    private final ConnectionInfo connectionInfo;
    private final InterceptorFactory interceptorFactory;
    private final ResourceMonitor connectionMonitor;
    private final AtomicInteger operationCounter = new AtomicInteger(1);

    protected JfrConnection42(Connection con) {
        this(con, InterceptorManager.getDefaultInterceptorFactory(), "userManagedConnection", new ConnectionInfo(null, 0, 0));
    }

    protected JfrConnection42(Connection con, String dataSourceLabel) {
        this(con, InterceptorManager.getDefaultInterceptorFactory(), dataSourceLabel, new ConnectionInfo(dataSourceLabel, 0, 0));
    }

    protected JfrConnection42(Connection con, InterceptorFactory factory) {
        this(con, factory, "userManagedConnection", new ConnectionInfo(null, 0, 0));
    }

    protected JfrConnection42(Connection con, InterceptorFactory factory, String dataSourceLabel) {
        this(con, factory, dataSourceLabel, new ConnectionInfo(dataSourceLabel, 0, 0));
    }

    private JfrConnection42(Connection con, InterceptorFactory factory, String label, ConnectionInfo connectionInfo) {
        this.connection = con;
        this.interceptorFactory = factory;
        ResourceMonitorManager manager = ResourceMonitorManager.getInstance(ResourceMonitorKind.Connection);
        this.connectionMonitor = manager.createConnectionMonitor(label, factory);
        this.connectionInfo = connectionInfo;
        this.connectionMonitor.useResource();
    }

    public JfrConnection42(Connection con, InterceptorFactory factory, ResourceMonitor connectionMonitor, ConnectionInfo connectionInfo) {
        this.connection = con;
        this.interceptorFactory = factory;
        this.connectionMonitor = connectionMonitor;
        this.connectionInfo = connectionInfo;
        this.connectionMonitor.useResource();
    }

    private JfrStatement createStatement(Statement s) {
        return new JfrStatement(s, this.interceptorFactory, this.connectionInfo, new OperationInfo(this.operationCounter.getAndIncrement()));
    }

    private JfrPreparedStatement createPreparedStatement(PreparedStatement p, String sql) {
        return new JfrPreparedStatement(p, sql, this.interceptorFactory, this.connectionInfo, new OperationInfo(this.operationCounter.getAndIncrement()));
    }

    private JfrCallableStatement createCallableStatement(CallableStatement c, String sql) {
        return new JfrCallableStatement(c, sql, this.interceptorFactory, this.connectionInfo, new OperationInfo(this.operationCounter.getAndIncrement()));
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public void commit() throws SQLException {
        Interceptor<CommitContext> interceptor = this.interceptorFactory.createCommitInterceptor();
        CommitContext context = new CommitContext(this.connection, this.connectionInfo, new OperationInfo(this.operationCounter.getAndIncrement()));
        try {
            interceptor.preInvoke(context);
            this.connection.commit();
        }
        catch (RuntimeException | SQLException e) {
            context.setException(e);
            throw e;
        }
        finally {
            interceptor.postInvoke(context);
        }
    }

    @Override
    public void rollback() throws SQLException {
        Interceptor<RollbackContext> interceptor = this.interceptorFactory.createRollbackInterceptor();
        RollbackContext context = new RollbackContext(this.connection, this.connectionInfo, new OperationInfo(this.operationCounter.getAndIncrement()));
        try {
            interceptor.preInvoke(context);
            this.connection.rollback();
        }
        catch (RuntimeException | SQLException e) {
            context.setException(e);
            throw e;
        }
        finally {
            interceptor.postInvoke(context);
        }
    }

    @Override
    public void close() throws SQLException {
        Interceptor<CloseContext> interceptor = this.interceptorFactory.createCloseInterceptor();
        CloseContext context = new CloseContext(this.connection, this.connectionInfo, new OperationInfo(this.operationCounter.getAndIncrement()));
        try {
            interceptor.preInvoke(context);
            this.connection.close();
        }
        catch (RuntimeException | SQLException e) {
            context.setException(e);
            throw e;
        }
        finally {
            interceptor.postInvoke(context);
            this.connectionMonitor.releaseResource();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement delegatePstate = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createPreparedStatement(delegatePstate, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement delegatePstate = this.connection.prepareStatement(sql, autoGeneratedKeys);
        return this.createPreparedStatement(delegatePstate, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement delegatePstate = this.connection.prepareStatement(sql, columnIndexes);
        return this.createPreparedStatement(delegatePstate, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement delegatePstate = this.connection.prepareStatement(sql, columnNames);
        return this.createPreparedStatement(delegatePstate, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement delegatePstate = this.connection.prepareStatement(sql);
        return this.createPreparedStatement(delegatePstate, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement delegatePstate = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return this.createPreparedStatement(delegatePstate, sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement delegateState = this.connection.createStatement();
        return this.createStatement(delegateState);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement delegateStates = this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createStatement(delegateStates);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement delegateState = this.connection.createStatement(resultSetType, resultSetConcurrency);
        return this.createStatement(delegateState);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement delegateCstate = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createCallableStatement(delegateCstate, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement delegateCstate = this.connection.prepareCall(sql);
        return this.createCallableStatement(delegateCstate, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement delegateCstate = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        return this.createCallableStatement(delegateCstate, sql);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }
}

