/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc;

import dev.jfr4jdbc.ResourceMonitor;
import dev.jfr4jdbc.ResourceMonitorKind;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ResourceMonitorManager {
    private static final Map<ResourceMonitorKind, ResourceMonitorManager> instances = new ConcurrentHashMap<ResourceMonitorKind, ResourceMonitorManager>(1);
    private final Map<String, ResourceMonitor> monitors = new ConcurrentHashMap<String, ResourceMonitor>();

    static final ResourceMonitorManager getInstance(ResourceMonitorKind kind) {
        return instances.computeIfAbsent(kind, k -> new ResourceMonitorManager());
    }

    ResourceMonitor getMonitor(String label) {
        return this.monitors.computeIfAbsent(label, id -> new ResourceMonitor((String)id));
    }

    List<ResourceMonitor> getMonitors() {
        return this.monitors.entrySet().stream().map(e -> (ResourceMonitor)e.getValue()).collect(Collectors.toList());
    }

    void addMonitor(ResourceMonitor monitor) {
        this.monitors.put(monitor.getLabel(), monitor);
    }
}

