/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc;

import dev.jfr4jdbc.EventFactory;
import dev.jfr4jdbc.JfrResultSet;
import dev.jfr4jdbc.JfrStatement;
import dev.jfr4jdbc.event.StatementEvent;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class JfrPreparedStatement
extends JfrStatement
implements PreparedStatement {
    private PreparedStatement jdbcStatement;
    private String sql;
    private Set<Parameter> parameters = new TreeSet<Parameter>();

    public JfrPreparedStatement(PreparedStatement p, String sql) {
        this(p, sql, EventFactory.getDefaultEventFactory());
    }

    public JfrPreparedStatement(PreparedStatement p, String sql, EventFactory factory) {
        super(p, factory);
        this.sql = sql;
        this.jdbcStatement = p;
    }

    private String parameterToString() {
        String parameterStr = this.parameters.stream().map(p -> String.format("%d=%s", p.index, p.value.toString())).collect(Collectors.joining(", "));
        return parameterStr;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        StatementEvent event = super.createEvent(this.sql);
        event.setPrepared(true);
        event.setParameter(this.parameterToString());
        this.parameters.clear();
        event.begin();
        ResultSet rs = null;
        try {
            rs = this.jdbcStatement.executeQuery();
        }
        catch (RuntimeException | SQLException e) {
            throw e;
        }
        finally {
            event.commit();
        }
        return new JfrResultSet(rs);
    }

    @Override
    public int executeUpdate() throws SQLException {
        StatementEvent event = super.createEvent(this.sql);
        event.setPrepared(true);
        event.setParameter(this.parameterToString());
        this.parameters.clear();
        event.begin();
        int ret = 0;
        try {
            ret = this.jdbcStatement.executeUpdate();
        }
        catch (RuntimeException | SQLException e) {
            throw e;
        }
        finally {
            event.commit();
        }
        return ret;
    }

    @Override
    public boolean execute() throws SQLException {
        StatementEvent event = super.createEvent(this.sql);
        event.setPrepared(true);
        event.setParameter(this.parameterToString());
        this.parameters.clear();
        event.begin();
        boolean ret = false;
        try {
            ret = this.jdbcStatement.execute();
        }
        catch (RuntimeException | SQLException e) {
            throw e;
        }
        finally {
            event.commit();
        }
        return ret;
    }

    @Override
    public void addBatch() throws SQLException {
        this.jdbcStatement.addBatch();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.jdbcStatement.setAsciiStream(parameterIndex, x, length);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.jdbcStatement.setUnicodeStream(parameterIndex, x, length);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.jdbcStatement.setBinaryStream(parameterIndex, x, length);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.jdbcStatement.clearParameters();
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.jdbcStatement.setObject(parameterIndex, x, targetSqlType);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.jdbcStatement.setCharacterStream(parameterIndex, reader, length);
        this.parameters.add(new Parameter(parameterIndex, reader));
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.jdbcStatement.setArray(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.jdbcStatement.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.jdbcStatement.setDate(parameterIndex, x, cal);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.jdbcStatement.setTime(parameterIndex, x, cal);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.jdbcStatement.setTimestamp(parameterIndex, x, cal);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.jdbcStatement.setNull(parameterIndex, sqlType, typeName);
        this.parameters.add(new Parameter(parameterIndex, typeName));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.jdbcStatement.setURL(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.jdbcStatement.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.jdbcStatement.setRowId(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.jdbcStatement.setNString(parameterIndex, value);
        this.parameters.add(new Parameter(parameterIndex, value));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.jdbcStatement.setNCharacterStream(parameterIndex, value, length);
        this.parameters.add(new Parameter(parameterIndex, value));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.jdbcStatement.setNClob(parameterIndex, value);
        this.parameters.add(new Parameter(parameterIndex, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.jdbcStatement.setClob(parameterIndex, reader, length);
        this.parameters.add(new Parameter(parameterIndex, reader));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.jdbcStatement.setBlob(parameterIndex, inputStream, length);
        this.parameters.add(new Parameter(parameterIndex, inputStream));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.jdbcStatement.setNClob(parameterIndex, reader, length);
        this.parameters.add(new Parameter(parameterIndex, reader));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.jdbcStatement.setSQLXML(parameterIndex, xmlObject);
        this.parameters.add(new Parameter(parameterIndex, xmlObject));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.jdbcStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.jdbcStatement.setAsciiStream(parameterIndex, x, length);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.jdbcStatement.setBinaryStream(parameterIndex, x, length);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.jdbcStatement.setCharacterStream(parameterIndex, reader, length);
        this.parameters.add(new Parameter(parameterIndex, reader));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.jdbcStatement.setAsciiStream(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.jdbcStatement.setBinaryStream(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.jdbcStatement.setCharacterStream(parameterIndex, reader);
        this.parameters.add(new Parameter(parameterIndex, reader));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.jdbcStatement.setNCharacterStream(parameterIndex, value);
        this.parameters.add(new Parameter(parameterIndex, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.jdbcStatement.setClob(parameterIndex, reader);
        this.parameters.add(new Parameter(parameterIndex, reader));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.jdbcStatement.setBlob(parameterIndex, inputStream);
        this.parameters.add(new Parameter(parameterIndex, inputStream));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.jdbcStatement.setNClob(parameterIndex, reader);
        this.parameters.add(new Parameter(parameterIndex, reader));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.jdbcStatement.setNull(parameterIndex, sqlType);
        this.parameters.add(new Parameter(parameterIndex, sqlType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.jdbcStatement.setBoolean(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.jdbcStatement.setByte(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.jdbcStatement.setShort(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.jdbcStatement.setInt(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.jdbcStatement.setLong(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.jdbcStatement.setFloat(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, Float.valueOf(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.jdbcStatement.setDouble(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.jdbcStatement.setBigDecimal(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.jdbcStatement.setString(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.jdbcStatement.setDate(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.jdbcStatement.setTime(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.jdbcStatement.setTimestamp(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.jdbcStatement.setObject(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.jdbcStatement.setRef(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.jdbcStatement.setBlob(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.jdbcStatement.setClob(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.jdbcStatement.setBytes(parameterIndex, x);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.jdbcStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.jdbcStatement.setObject(parameterIndex, x, targetSqlType);
        this.parameters.add(new Parameter(parameterIndex, x));
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.jdbcStatement.executeLargeUpdate();
    }

    class Parameter
    implements Comparable<Parameter> {
        final int index;
        final Object value;

        public Parameter(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.index == parameter.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        @Override
        public int compareTo(Parameter o) {
            return this.index - o.index;
        }
    }
}

