/*
 * Decompiled with CFR 0.152.
 */
package dev.jfr4jdbc;

import dev.jfr4jdbc.EventFactory;
import dev.jfr4jdbc.Jfr4JdbcRuntimeException;
import dev.jfr4jdbc.JfrConnection;
import dev.jfr4jdbc.event.ConnectEvent;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class Jfr4JdbcDriver
implements Driver {
    private static final String JFR4JDBC_URL_PREFIX = "jdbc:jfr";
    private static final int JFR4JDBC_URL_PREFIX_LENGTH = "jdbc:jfr".length();
    private Driver delegateJdbcDriver;
    private EventFactory factory = EventFactory.getDefaultEventFactory();

    private static final String getDelegateUrl(String url) {
        String delegateUrl = "jdbc" + url.substring(JFR4JDBC_URL_PREFIX_LENGTH);
        return delegateUrl;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (!url.startsWith(JFR4JDBC_URL_PREFIX)) {
            return false;
        }
        String delegeteJdbcDriverUrl = Jfr4JdbcDriver.getDelegateUrl(url);
        Driver delegateDriver = DriverManager.getDriver(delegeteJdbcDriverUrl);
        return delegateDriver != null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!url.startsWith(JFR4JDBC_URL_PREFIX)) {
            return null;
        }
        String delegeteUrl = Jfr4JdbcDriver.getDelegateUrl(url);
        Driver delegateDriver = DriverManager.getDriver(delegeteUrl);
        if (delegateDriver == null) {
            return null;
        }
        this.delegateJdbcDriver = delegateDriver;
        ConnectEvent event = this.factory.createConnectEvent();
        event.setUrl(delegeteUrl);
        event.begin();
        Connection delegatedCon = null;
        try {
            delegatedCon = delegateDriver.connect(delegeteUrl, info);
            if (delegatedCon != null) {
                event.setConnectionClass(delegatedCon.getClass());
            }
        }
        catch (RuntimeException | SQLException e) {
            event.commit();
            throw e;
        }
        if (delegatedCon == null) {
            event.commit();
            throw new SQLException("Invalid driver url: " + url);
        }
        event.setConnectionId(System.identityHashCode(delegatedCon));
        event.commit();
        return new JfrConnection(delegatedCon);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (this.delegateJdbcDriver == null) {
            throw new Jfr4JdbcRuntimeException("No delegate Driver");
        }
        return this.delegateJdbcDriver.getPropertyInfo(Jfr4JdbcDriver.getDelegateUrl(url), info);
    }

    @Override
    public int getMajorVersion() {
        if (this.delegateJdbcDriver == null) {
            throw new Jfr4JdbcRuntimeException("No delegate Driver");
        }
        return this.delegateJdbcDriver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        if (this.delegateJdbcDriver == null) {
            throw new Jfr4JdbcRuntimeException("No delegate Driver");
        }
        return this.delegateJdbcDriver.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        if (this.delegateJdbcDriver == null) {
            throw new Jfr4JdbcRuntimeException("No delegate Driver");
        }
        return this.delegateJdbcDriver.getParentLogger();
    }

    static {
        try {
            DriverManager.registerDriver(new Jfr4JdbcDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register Jfr4Jdbc.", e);
        }
    }
}

