# Image Storage
This library also provides a simple way to store, retrieve and delete the images generated by `ImageCapture`.
It currently supports two different storage methods: local storage, and S3.
Images will be stored in PNG format.

## Configuration
Configuration of the storage provider can be done via the `storage.yml` file inside the plugin data folder.
By default, storage is not enabled.
You can change this behaviour by changing the `provider`.
The standard config looks something like this:
```yaml
# local, s3 or none
provider: none

s3:
  endpoint:
  region:
  access_key:
  secret_key:
  bucket:
```

Just change `provider` to `local` to enable local storage.
Do restart your server for the changes to take effect.

Enable S3 storage by setting `provider` to `s3` and adding the config options under the s3 section.
It should look something like this (example with CloudFlare R2):
```yaml
# local, s3 or none
provider: s3

s3:
  endpoint: https://<your account>.r2.cloudflarestorage.com
  region: auto
  access_key: <access_key>
  secret_key: <secret_key>
  bucket: <bucket name>
```

## Developer API
Using the API is pretty simple.
There are simple fetch, store and remove methods available.

First of all, it is not guaranteed that the user of your plugin has storage enabled.
Please first check this by checking if `ImageryAPIPlugin.storage` exists.
Something like this should be done in the plugin initializer:
```java
boolean storageEnabled = ImageryAPIPlugin.storage != null;
if (storageEnabled) {
    Bukkit.getLogger().info("Storage enabled.");
} else {
    // could also be a warn depending on your application
    Bukkit.getLogger().info("Storage disabled. Saving images not available.");
}
```

`ImageryAPIPlugin.storage` can be used to perform all storage operations.
Image references are UUIDs,
so make sure to save these UUIDs in your own plugin,
as you won't be able to fetch images otherwise.

Fetching: `ImageryAPIPlugin.storage.fetch(UUID uuid)`

Store: `ImageryAPIPlugin.storage.store(BufferedImage image)`

Removing: `ImageryAPIPlugin.storage.remove(UUID uuid)`

Calling these methods may result in a `StorageException`, which should be caught.
These may be caused by incorrect permissions, disk usage (local storage)
or S3 availability (S3).

### S3 specific methods
The S3 storage provider also supports generating presigned urls.
This can be used to link the player to an image,
or pass the image to another system that doesn't have S3 access.
**You should always check if the current storage provider has download url capabilities**.

Checking for capabilities:
```java
boolean canGenerateUrl = ImageryAPIPlugin.storage.downloadUrlEnabled();
if (canGenerateUrl) {
    // call generateDownloadUrl use the url
} else {
    // could also be a warn depending on your application
    Bukkit.getLogger().info("Storage provider doesn't implement download url generation");
}
```

The presigned url has a validity of 1 day,
which should be enough for any real world use case.