/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.examples.templates;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.project.JkIdeSupport;
import dev.jeka.core.api.project.JkIdeSupportSupplier;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkInjectProperty;
import dev.jeka.plugins.jacoco.JkJacoco;
import dev.jeka.plugins.nodejs.JkNodeJs;
import dev.jeka.plugins.sonarqube.JkSonarqube;
import dev.jeka.plugins.springboot.JkSpringboot;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@JkDoc(value={"Builds a Spring-Boot project, optionally containing a reactjs frontend.\nThis build handles Java compilation, Junit testing with coverage, reactjs build, Sonarqube analysis.\n\nThis template is designed to be rigid for enforcing a common usage of tools and layout.\nTThe project dependencies are supposed to be declared in <i>jeka/project-dependencies.txt</i> file.\n\nThe project version, along the SonarQube host/token props, are expected to be injected by the CI tool.\n"})
public class SpringBootTemplateBuild
extends JkBean
implements JkIdeSupportSupplier {
    @JkDepSuggest(versionOnly=true, hint="org.jacoco:org.jacoco.agent:")
    public static final String JACOCO_VERSION = "0.8.11";
    @JkDepSuggest(versionOnly=true, hint="org.sonarsource.scanner.cli:sonar-scanner-cli:")
    public static final String SONARQUBE_VERSION = "5.0.1.3006";
    public static final String NODEJS_VERSION = "20.10.0";
    public static final String REACTJS_BASE_DIR = "reactjs-client";
    @JkDoc(value={"Spring-Boot version"})
    @JkDepSuggest(versionOnly=true, hint="org.springframework.boot:spring-boot-starter-parent:")
    public String springbootVersion = "3.2.0";
    @JkDepSuggest(versionOnly=true, hint="20.10.0,18.19.0,16.20.2")
    public String nodeJsVersion = "20.10.0";
    @JkDoc(value={"The project key formatted as group:name that will be used for naming artifacts."})
    public String moduleId = "org.myorg:" + this.getBaseDir().toAbsolutePath().getFileName();
    @JkDoc(value={"Project version injected by CI/CD tool"})
    @JkInjectProperty(value="PROJECT_VERSION")
    public String projectVersion;

    @JkDoc(value={"Performs a simple build, without code coverage"})
    public void pack() {
        this.project().clean().pack();
    }

    @JkDoc(value={"Performs a build including quality static analysis."})
    public void packQuality() {
        JkProject jkProject = this.project();
        JkJacoco.ofVersion((JkDependencyResolver)this.getRuntime().getDependencyResolver(), (String)JACOCO_VERSION).configureForAndApplyTo(jkProject);
        jkProject.clean().pack();
        this.sonarqubeBase().configureFor(jkProject).setProperties(this.getRuntime().getProperties().getAllStartingWith("sonar.", true)).run();
        if (Files.exists(this.reactBaseDir(), new LinkOption[0])) {
            this.sonarqubeBase().setProperty("projectKey", jkProject.publication.getModuleId().getColonNotation() + "-js").setProperty("projectVersion", this.projectVersion).setProperty("language", "javascript").setProperty("sources", REACTJS_BASE_DIR).setProperty("exclusions", "node_modules").setProperties(this.getRuntime().getProperties()).run();
        }
    }

    @JkDoc(value={"Executes the built bootable jar"})
    public void runJar() {
        this.project().runMainJar(false, "", "");
    }

    @JkDoc(value={"Displays the dependency tree on the console."})
    public void depTree() {
        this.project().displayDependencyTree();
    }

    public JkIdeSupport getJavaIdeSupport() {
        return this.project().getJavaIdeSupport();
    }

    private JkProject project() {
        JkProject jkProject = JkProject.of();
        jkProject.publication.setModuleId(this.moduleId);
        jkProject.publication.setVersion(this.projectVersion);
        jkProject.packaging.manifest.addMainAttribute("Implementation-Version", this.projectVersion);
        JkSpringboot.of().setSpringbootVersion(this.springbootVersion).configure(jkProject);
        if (Files.exists(this.reactBaseDir(), new LinkOption[0])) {
            JkNodeJs.ofVersion((String)this.nodeJsVersion).configure(jkProject, REACTJS_BASE_DIR, "build", new String[]{"npx yarn install ", "npm run build"});
        }
        return jkProject;
    }

    private Path reactBaseDir() {
        return this.getBaseDir().resolve(REACTJS_BASE_DIR);
    }

    private JkSonarqube sonarqubeBase() {
        return JkSonarqube.ofVersion((JkDependencyResolver)this.getRuntime().getDependencyResolver(), (String)SONARQUBE_VERSION);
    }
}

