/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.springboot;

import dev.jeka.core.api.depmanagement.JkArtifactId;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.java.JkUrlClassLoader;
import dev.jeka.core.api.java.project.JkJavaProject;
import dev.jeka.core.api.java.project.JkJavaProjectMaker;
import dev.jeka.core.api.system.JkException;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.tooling.JkPom;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.tool.JkCommandSet;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkDocPluginDeps;
import dev.jeka.core.tool.JkPlugin;
import dev.jeka.core.tool.builtins.java.JkPluginJava;
import dev.jeka.core.tool.builtins.scaffold.JkPluginScaffold;
import dev.jeka.plugins.springboot.JkSpringModules;
import dev.jeka.plugins.springboot.JkSpringRepos;
import dev.jeka.plugins.springboot.SpringbootPacker;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

@JkDoc(value={"Provides enhancement to Java plugin in order to produce a startable Springboot jar for your application.\nThe main produced artifact is the springboot one (embedding all dependencies) while the artifact classified as 'original' stands for the vanilla jar.\nDependency versions are resolved against BOM provided by Spring Boot team according Spring Boot version you use."})
@JkDocPluginDeps(value={JkPluginJava.class})
public final class JkPluginSpringboot
extends JkPlugin {
    @JkDoc(value={"Version of Spring Boot version used to resolve dependency versions."})
    private String springbootVersion = "2.0.3.RELEASE";
    @JkDoc(value={"Class name holding main method to start Spring Boot. If null, Jerkar will try to guess it at build time."})
    public String mainClassName;
    @JkDoc(value={"If true, Spring Milestone or Snapshot Repository will be used to fetch non release version of spring modules"})
    public boolean autoSpringRepo = true;
    private final JkPluginJava java;

    protected JkPluginSpringboot(JkCommandSet jkCommandSet) {
        super(jkCommandSet);
        this.java = (JkPluginJava)jkCommandSet.getPlugins().get(JkPluginJava.class);
    }

    protected String getLowestJekaCompatibleVersion() {
        return "0.8.18.RELEASE";
    }

    public void setSpringbootVersion(String string) {
        this.springbootVersion = string;
    }

    @JkDoc(value={"Modifies the Java project from Java plugin in such this project produces a SpringBoot jar as the main artifact."})
    protected void activate() {
        this.activate(this.java.getProject());
    }

    public void activate(JkJavaProject jkJavaProject) {
        JkRepoSet jkRepoSet;
        JkJavaProjectMaker jkJavaProjectMaker = jkJavaProject.getMaker();
        JkVersion jkVersion = JkVersion.of((String)this.springbootVersion);
        if (this.autoSpringRepo && jkVersion.hasBlockAt(3)) {
            jkRepoSet = JkSpringRepos.getRepoForVersion(jkVersion.getBlock(3));
            jkJavaProjectMaker.setDependencyResolver(jkJavaProjectMaker.getDependencyResolver().andRepos(jkRepoSet));
        }
        jkRepoSet = jkJavaProjectMaker.getDependencyResolver().getRepos();
        JkVersionProvider jkVersionProvider = JkPluginSpringboot.resolveVersions(jkRepoSet, this.springbootVersion);
        jkJavaProject.setDependencies(jkJavaProject.getDependencies().andVersionProvider(jkVersionProvider));
        jkJavaProjectMaker.removeArtifact(jkJavaProjectMaker.getMainArtifactId());
        JkArtifactId jkArtifactId = JkArtifactId.of((String)"original", (String)"jar");
        Path path = jkJavaProjectMaker.getArtifactPath(jkArtifactId);
        JkArtifactId jkArtifactId2 = jkJavaProjectMaker.getMainArtifactId();
        jkJavaProjectMaker.putArtifact(jkArtifactId, () -> jkJavaProjectMaker.getTasksForPackaging().createBinJar(jkJavaProjectMaker.getArtifactPath(jkArtifactId)));
        JkVersion jkVersion2 = jkVersionProvider.getVersionOf(JkSpringModules.Boot.LOADER);
        Path path2 = jkJavaProjectMaker.getDependencyResolver().getRepos().get(JkSpringModules.Boot.LOADER, jkVersion2.getValue());
        jkJavaProjectMaker.putArtifact(jkArtifactId2, () -> {
            if (!Files.exists(path, new LinkOption[0])) {
                jkJavaProjectMaker.makeArtifact(jkArtifactId);
            }
            JkPathSequence jkPathSequence = jkJavaProjectMaker.fetchRuntimeDependencies(jkArtifactId2);
            JkPluginSpringboot.createBootJar(path, jkPathSequence, path2, jkJavaProjectMaker.getMainArtifactPath(), this.springbootVersion, this.mainClassName);
        });
        if (this.getCommandSet().getPlugins().hasLoaded(JkPluginScaffold.class)) {
            JkPluginScaffold jkPluginScaffold = (JkPluginScaffold)this.getCommandSet().getPlugins().get(JkPluginScaffold.class);
            String string = JkUtilsIO.read((URL)JkPluginSpringboot.class.getResource("Build.java.snippet"));
            jkPluginScaffold.getScaffolder().setCommandClassCode(string);
        }
    }

    public JkPluginJava javaPlugin() {
        return this.java;
    }

    public static JkVersionProvider resolveVersions(JkRepoSet jkRepoSet, String string) {
        JkModuleDependency jkModuleDependency = JkModuleDependency.of((String)"org.springframework.boot", (String)"spring-boot-dependencies", (String)string).withExt("pom");
        JkLog.info((String)("Fetch Springboot dependency versions from " + jkModuleDependency));
        Path path = jkRepoSet.get(jkModuleDependency);
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            throw new JkException(jkModuleDependency + " not found");
        }
        JkPom jkPom = JkPom.of((Path)path);
        JkLog.info((String)("Springboot dependency versions will be resolved from " + path));
        return jkPom.getVersionProvider();
    }

    public static void createBootJar(Path path, JkPathSequence jkPathSequence, Path path2, Path path3, String string, String string2) {
        List list = JkUrlClassLoader.of((Iterable)path).toJkClassLoader().findClassesHavingMainMethod();
        if (list.isEmpty()) {
            throw new JkException("No classes with main method found");
        }
        String string3 = string2 != null ? string2 : (String)list.get(0);
        SpringbootPacker.of(jkPathSequence, path2, string3, string).makeExecJar(path, path3);
    }
}

