/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.springboot;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;

class JarWriter {
    private static final String NESTED_LOADER_JAR = "META-INF/loader/spring-boot-loader.jar";
    private static final int BUFFER_SIZE = 32768;
    private final JarOutputStream jarOutput;
    private final Set<String> writtenEntries = new HashSet<String>();

    public JarWriter(Path path) throws FileNotFoundException, IOException {
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        this.jarOutput = new JarOutputStream(outputStream);
    }

    public void writeManifest(final Manifest manifest) throws IOException {
        JarEntry jarEntry = new JarEntry("META-INF/MANIFEST.MF");
        this.writeEntry(jarEntry, new EntryWriter(){

            @Override
            public void write(OutputStream outputStream) throws IOException {
                manifest.write(outputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEntries(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            try (ZipHeaderPeekInputStream zipHeaderPeekInputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(jarEntry));){
                if (zipHeaderPeekInputStream.hasZipHeader() && jarEntry.getMethod() != 0) {
                    new CrcAndSize(zipHeaderPeekInputStream).setupStoredEntry(jarEntry);
                    zipHeaderPeekInputStream.close();
                    zipHeaderPeekInputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(jarEntry));
                }
                InputStreamEntryWriter inputStreamEntryWriter = new InputStreamEntryWriter(zipHeaderPeekInputStream, true);
                this.writeEntry(jarEntry, inputStreamEntryWriter);
            }
        }
    }

    public void writeEntry(String string, InputStream inputStream) throws IOException {
        JarEntry jarEntry = new JarEntry(string);
        this.writeEntry(jarEntry, new InputStreamEntryWriter(inputStream, true));
    }

    public void writeNestedLibrary(String string, Path path) throws IOException {
        JarEntry jarEntry = new JarEntry(string + path.getFileName().toString());
        jarEntry.setTime(this.getNestedLibraryTime(path));
        new CrcAndSize(path).setupStoredEntry(jarEntry);
        this.writeEntry(jarEntry, new InputStreamEntryWriter(Files.newInputStream(path, new OpenOption[0]), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getNestedLibraryTime(Path path) {
        try (JarFile jarFile = new JarFile(path.toFile());){
            JarEntry jarEntry;
            Enumeration<JarEntry> enumeration = jarFile.entries();
            do {
                if (!enumeration.hasMoreElements()) return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            } while ((jarEntry = enumeration.nextElement()).isDirectory());
            long l = jarEntry.getTime();
            return l;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public void writeLoaderClasses(URL uRL) throws IOException {
        JarEntry jarEntry;
        JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(uRL.openStream()));
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (!jarEntry.getName().endsWith(".class")) continue;
            this.writeEntry(jarEntry, new InputStreamEntryWriter(jarInputStream, false));
        }
        jarInputStream.close();
    }

    public void close() throws IOException {
        this.jarOutput.close();
    }

    private void writeEntry(JarEntry jarEntry, EntryWriter entryWriter) throws IOException {
        String string = jarEntry.getName();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.lastIndexOf("/") != -1 && (string = string.substring(0, string.lastIndexOf("/") + 1)).length() > 0) {
            this.writeEntry(new JarEntry(string), null);
        }
        if (this.writtenEntries.add(jarEntry.getName())) {
            this.jarOutput.putNextEntry(jarEntry);
            if (entryWriter != null) {
                entryWriter.write(this.jarOutput);
            }
            this.jarOutput.closeEntry();
        }
    }

    void setExecutableFilePermission(Path path) {
        try {
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
            hashSet.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, hashSet);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class CrcAndSize {
        private final CRC32 crc = new CRC32();
        private long size;

        CrcAndSize(Path path) throws IOException {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                this.load(inputStream);
            }
        }

        CrcAndSize(InputStream inputStream) throws IOException {
            this.load(inputStream);
        }

        private void load(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[32768];
            int n = -1;
            while ((n = inputStream.read(byArray)) != -1) {
                this.crc.update(byArray, 0, n);
                this.size += (long)n;
            }
        }

        public void setupStoredEntry(JarEntry jarEntry) {
            jarEntry.setSize(this.size);
            jarEntry.setCompressedSize(this.size);
            jarEntry.setCrc(this.crc.getValue());
            jarEntry.setMethod(0);
        }
    }

    private static class ZipHeaderPeekInputStream
    extends FilterInputStream {
        private static final byte[] ZIP_HEADER = new byte[]{80, 75, 3, 4};
        private final byte[] header = new byte[4];
        private ByteArrayInputStream headerStream;

        protected ZipHeaderPeekInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            int n = inputStream.read(this.header);
            this.headerStream = new ByteArrayInputStream(this.header, 0, n);
        }

        @Override
        public int read() throws IOException {
            int n;
            int n2 = n = this.headerStream == null ? -1 : this.headerStream.read();
            if (n != -1) {
                this.headerStream = null;
                return n;
            }
            return super.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n3 = this.headerStream == null ? -1 : this.headerStream.read(byArray, n, n2);
            if (n3 != -1) {
                this.headerStream = null;
                return n3;
            }
            return super.read(byArray, n, n2);
        }

        public boolean hasZipHeader() {
            return Arrays.equals(this.header, ZIP_HEADER);
        }
    }

    private static class InputStreamEntryWriter
    implements EntryWriter {
        private final InputStream inputStream;
        private final boolean close;

        InputStreamEntryWriter(InputStream inputStream, boolean bl) {
            this.inputStream = inputStream;
            this.close = bl;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            byte[] byArray = new byte[32768];
            int n = -1;
            while ((n = this.inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            if (this.close) {
                this.inputStream.close();
            }
        }
    }

    private static interface EntryWriter {
        public void write(OutputStream var1) throws IOException;
    }
}

