/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.springboot;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkManifest;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.plugins.springboot.JarWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class SpringbootPacker {
    private final JkPathSequence nestedLibs;
    private final Path bootLoaderJar;
    private final JkManifest manifestToMerge;
    private final String mainClassName;
    private final String springbootVersion;

    private SpringbootPacker(JkPathSequence jkPathSequence, Path path, String string, JkManifest jkManifest, String string2) {
        this.nestedLibs = jkPathSequence;
        this.bootLoaderJar = path;
        this.manifestToMerge = jkManifest;
        this.mainClassName = string;
        this.springbootVersion = string2;
    }

    public static final SpringbootPacker of(JkPathSequence jkPathSequence, Path path, String string, String string2) {
        return new SpringbootPacker(jkPathSequence, path, string, null, string2);
    }

    public void makeExecJar(Path path, Path path2) {
        try {
            this.makeBootJarChecked(path, path2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void makeBootJarChecked(Path path, Path path2) throws IOException {
        JarWriter jarWriter = new JarWriter(path2);
        Path path3 = JkPathTree.ofZip((Path)path).goTo("META-INF").get("MANIFEST.MF");
        JkManifest jkManifest = Files.exists(path3, new LinkOption[0]) ? JkManifest.of((Path)path3) : JkManifest.ofEmpty();
        jarWriter.writeManifest(this.createManifest(jkManifest, this.mainClassName).getManifest());
        for (Path path4 : this.nestedLibs) {
            jarWriter.writeNestedLibrary("BOOT-INF/lib/", path4);
        }
        jarWriter.writeLoaderClasses(this.bootLoaderJar.toUri().toURL());
        this.writeClasses(path, jarWriter);
        jarWriter.close();
        jarWriter.setExecutableFilePermission(path2);
    }

    private void writeClasses(Path path2, JarWriter jarWriter) {
        JkPathTree jkPathTree = JkPathTree.ofZip((Path)path2);
        jkPathTree.stream(new FileVisitOption[0]).filter(path -> !path.toString().endsWith("/")).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
            String string = "BOOT-INF/classes" + path.toString();
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                jarWriter.writeEntry(string, inputStream);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
    }

    private JkManifest createManifest(JkManifest jkManifest, String string) {
        JkManifest jkManifest2 = (JkManifest)JkUtilsObject.firstNonNull((Object[])new JkManifest[]{jkManifest, JkManifest.ofEmpty()});
        jkManifest2.addMainAttribute("Spring-Boot_Version", this.springbootVersion);
        jkManifest2.addMainClass("org.springframework.boot.loader.JarLauncher");
        jkManifest2.addMainAttribute("Start-Class", string);
        jkManifest2.addMainAttribute("Spring-Boot-Classes", "BOOT-INF/classes/");
        jkManifest2.addMainAttribute("Spring-Boot-Lib", "BOOT-INF/lib/");
        jkManifest2.addContextualInfo();
        if (this.manifestToMerge != null) {
            jkManifest2.merge(this.manifestToMerge);
        }
        return jkManifest2;
    }
}

