/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.springboot;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkZipTree;
import dev.jeka.core.api.java.JkManifest;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.plugins.springboot.JarWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;

class SpringbootPacker {
    private final JkPathSequence nestedLibs;
    private final Path bootLoaderJar;
    private final JkManifest manifestToMerge;
    private final String mainClassName;

    private SpringbootPacker(JkPathSequence jkPathSequence, Path path, String string, JkManifest jkManifest) {
        this.nestedLibs = jkPathSequence;
        this.bootLoaderJar = path;
        this.manifestToMerge = jkManifest;
        this.mainClassName = string;
    }

    public static final SpringbootPacker of(JkPathSequence jkPathSequence, Path path, String string, String string2) {
        return new SpringbootPacker(jkPathSequence, path, string, null);
    }

    public void makeExecJar(Path path, Path path2) {
        try {
            this.makeBootJarChecked(path, path2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void makeBootJarChecked(Path path, Path path2) throws IOException {
        JarWriter jarWriter = new JarWriter(path2);
        JkZipTree jkZipTree = JkZipTree.of((Path)path);
        Object object2 = null;
        try {
            Path path3 = ((JkZipTree)jkZipTree.goTo("META-INF")).get("MANIFEST.MF");
            JkManifest jkManifest = Files.exists(path3, new LinkOption[0]) ? JkManifest.of().loadFromFile(path3) : JkManifest.of();
            jarWriter.writeManifest(this.createManifest(jkManifest, this.mainClassName).getManifest());
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (jkZipTree != null) {
                if (object2 != null) {
                    try {
                        jkZipTree.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    jkZipTree.close();
                }
            }
        }
        for (Object object2 : this.nestedLibs.withoutDuplicates()) {
            jarWriter.writeNestedLibrary("BOOT-INF/lib/", (Path)object2);
        }
        jarWriter.writeLoaderClasses(this.bootLoaderJar.toUri().toURL());
        this.writeClasses(path, jarWriter);
        jarWriter.close();
        jarWriter.setExecutableFilePermission(path2);
        JkLog.info((String)("Bootable jar created at " + path2), (Object[])new Object[0]);
    }

    private void writeClasses(Path path2, JarWriter jarWriter) {
        JkZipTree jkZipTree = JkZipTree.of((Path)path2);
        Stream stream = jkZipTree.stream(new FileVisitOption[0]);
        stream.filter(path -> !path.toString().endsWith("/")).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
            String string = "BOOT-INF/classes" + path.toString();
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                jarWriter.writeEntry(string, inputStream);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
    }

    private JkManifest createManifest(JkManifest jkManifest, String string) {
        JkManifest jkManifest2 = ((JkManifest)JkUtilsObject.firstNonNull((Object[])new JkManifest[]{jkManifest, JkManifest.of()})).addMainClass("org.springframework.boot.loader.JarLauncher").addMainAttribute("Start-Class", string).addMainAttribute("Spring-Boot-Classes", "BOOT-INF/classes/").addMainAttribute("Spring-Boot-Lib", "BOOT-INF/lib/");
        jkManifest2.addContextualInfo();
        if (this.manifestToMerge != null) {
            jkManifest2.merge(this.manifestToMerge.getManifest());
        }
        return jkManifest2;
    }
}

