/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.springboot;

import dev.jeka.core.api.depmanagement.JkCoordinateDependency;
import dev.jeka.core.api.depmanagement.JkCoordinateFileProxy;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.artifact.JkStandardFileArtifactProducer;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.j2e.JkJ2eWarProjectAdapter;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkManifest;
import dev.jeka.core.api.java.JkUrlClassLoader;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectPackaging;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.tooling.JkPom;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.core.tool.builtins.scaffold.JkScaffolder;
import dev.jeka.core.tool.builtins.scaffold.ScaffoldJkBean;
import dev.jeka.plugins.springboot.JkSpringModules;
import dev.jeka.plugins.springboot.JkSpringRepos;
import dev.jeka.plugins.springboot.SpringbootPacker;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.function.Consumer;

@JkDoc(value={"Configure project KBean in order to produce bootable springboot jar and war files."})
public final class SpringbootJkBean
extends JkBean {
    private static final String DEFAULT_SPRINGBOOT_VERSION = "2.7.7";
    public static final JkArtifactId ORIGINAL_ARTIFACT = JkArtifactId.of((String)"original", (String)"jar");
    private static final String SPRINGBOOT_APPLICATION_ANNOTATION_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private static final String BOM_COORDINATE = "org.springframework.boot:spring-boot-dependencies::pom:";
    public static final String SPRING_BOOT_VERSION_MANIFEST_ENTRY = "Spring-Boot-Version";
    @JkDoc(value={"Version of Spring Boot version used to resolve dependency versions."})
    private String springbootVersion = "2.7.7";
    @JkDoc(value={"Command arg line to pass to springboot for #run method (e.g. '--server.port=8083 -Dspring.profiles.active=prod'"})
    public String runArgs;
    @JkDoc(value={"If true, create a bootable jar artifact."})
    public boolean createBootJar = true;
    @JkDoc(value={"If true, create original jar artifact for publication (jar without embedded dependencies"})
    public boolean createOriginalJar;
    @JkDoc(value={"If true, create a .war filed."})
    public boolean createWarFile;
    @JkDoc(value={"For internal test purpose. If not null, scaffolded build class will reference this classpath for springboot plugin dependency."})
    public String scaffoldDefClasspath;
    private boolean useSpringRepos = true;
    public final ProjectJkBean projectBean = ((ProjectJkBean)this.getBean(ProjectJkBean.class)).configure(this::configure);

    public SpringbootJkBean setSpringbootVersion(String string) {
        ((ScaffoldJkBean)this.getBean(ScaffoldJkBean.class)).configure(this::configure);
        this.springbootVersion = string;
        return this;
    }

    private void configure(JkProject jkProject) {
        Consumer<Path> consumer;
        JkRepoSet jkRepoSet;
        JkDependencyResolver jkDependencyResolver = jkProject.dependencyResolver;
        JkVersion jkVersion = JkVersion.of((String)this.springbootVersion);
        if (this.useSpringRepos && jkVersion.hasBlockAt(3)) {
            jkRepoSet = JkSpringRepos.getRepoForVersion(jkVersion.getBlock(3));
            jkDependencyResolver.addRepos(jkRepoSet);
        }
        jkProject.testing.testProcessor.setForkingProcess(true);
        jkProject.includeJavadocAndSources(false, false);
        jkProject.packaging.manifest.addMainAttribute(SPRING_BOOT_VERSION_MANIFEST_ENTRY, this.springbootVersion);
        jkProject.compilation.configureDependencies(jkDependencySet -> jkDependencySet.andBom(BOM_COORDINATE + this.springbootVersion));
        jkRepoSet = jkProject.artifactProducer;
        if (this.createBootJar) {
            consumer = path -> this.createBootJar(jkProject, (Path)path);
            jkRepoSet.putMainArtifact(consumer);
        }
        if (this.createWarFile) {
            consumer = path -> JkJ2eWarProjectAdapter.of().generateWar(path, jkProject);
            jkRepoSet.putArtifact("", "war", consumer);
        }
        if (this.createOriginalJar) {
            consumer = arg_0 -> ((JkProjectPackaging)jkProject.packaging).createBinJar(arg_0);
            jkRepoSet.putArtifact(ORIGINAL_ARTIFACT, consumer);
        }
    }

    private void configure(JkScaffolder jkScaffolder) {
        String string = JkUtilsIO.read((URL)SpringbootJkBean.class.getClassLoader().getResource("src/snippet/Build.java"));
        String string2 = this.scaffoldDefClasspath != null ? this.scaffoldDefClasspath.replace("\\", "/") : "dev.jeka:springboot-plugin";
        string = string.replace("${dependencyDescription}", string2);
        String string3 = string = string.replace("${springbootVersion}", this.latestSpringbootVersion(this.projectBean.getProject()));
        if (this.projectBean.scaffold.template != ProjectJkBean.JkScaffoldOptions.Template.CODE_LESS) {
            jkScaffolder.setJekaClassCodeProvider(() -> string3);
        }
        jkScaffolder.extraActions.append(this::scaffoldSample);
        String string4 = JkUtilsIO.read((URL)SpringbootJkBean.class.getClassLoader().getResource("src/snippet/README.md"));
        jkScaffolder.extraActions.append(() -> {
            JkPathFile jkPathFile = JkPathFile.of((Path)this.getBaseDir().resolve("README.md")).createIfNotExist();
            jkPathFile.write(string4.getBytes(StandardCharsets.UTF_8), new OpenOption[]{StandardOpenOption.APPEND});
        });
    }

    private void createBootJar(JkProject jkProject) {
        JkStandardFileArtifactProducer jkStandardFileArtifactProducer = jkProject.artifactProducer;
        this.createBootJar(jkProject, jkStandardFileArtifactProducer.getMainArtifactPath());
    }

    private void createBootJar(JkProject jkProject, Path path) {
        Path path2 = jkProject.artifactProducer.getArtifactPath(ORIGINAL_ARTIFACT);
        if (!Files.exists(path2, new LinkOption[0])) {
            jkProject.packaging.createBinJar(path2);
        }
        JkLog.startTask((String)"Packaging bootable jar", (Object[])new Object[0]);
        JkStandardFileArtifactProducer jkStandardFileArtifactProducer = jkProject.artifactProducer;
        JkDependencyResolver jkDependencyResolver = jkProject.dependencyResolver;
        JkCoordinateFileProxy jkCoordinateFileProxy = JkCoordinateFileProxy.of((JkRepoSet)jkDependencyResolver.getRepos(), (String)(BOM_COORDINATE + this.springbootVersion));
        Path path3 = jkCoordinateFileProxy.get();
        JkPathSequence jkPathSequence = jkDependencyResolver.resolve(jkProject.packaging.getRuntimeDependencies().normalised(jkProject.getDuplicateConflictStrategy())).getFiles();
        SpringbootJkBean.createBootJar(path2, jkPathSequence, path3, jkStandardFileArtifactProducer.getMainArtifactPath(), this.springbootVersion);
        JkLog.endTask();
    }

    public void createBootJar() {
        this.createBootJar(this.projectBean.getProject());
    }

    private static JkPom getSpringbootBom(JkDependencyResolver jkDependencyResolver, String string) {
        JkCoordinateDependency jkCoordinateDependency = JkCoordinateDependency.of((String)(BOM_COORDINATE + string));
        JkLog.info((String)("Fetch Springboot dependency versions from " + jkCoordinateDependency), (Object[])new Object[0]);
        Path path = (Path)jkDependencyResolver.resolve(jkCoordinateDependency).getFiles().getEntries().get(0);
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            throw new IllegalStateException(jkCoordinateDependency + " not found");
        }
        JkLog.info((String)("Springboot dependency versions will be resolved from " + path), (Object[])new Object[0]);
        return JkPom.of((Path)path);
    }

    public static void createBootJar(Path path, JkPathSequence jkPathSequence, Path path2, Path path3, String string) {
        JkUtilsAssert.argument((boolean)Files.exists(path, new LinkOption[0]), (String)("Original jar not found at " + path), (Object[])new Object[0]);
        JkClassLoader jkClassLoader = JkUrlClassLoader.of((Iterable)path, (ClassLoader)ClassLoader.getSystemClassLoader().getParent()).toJkClassLoader();
        List list2 = jkClassLoader.findClassesHavingMainMethod();
        List list3 = jkClassLoader.findClassesMatchingAnnotations(list -> list.contains(SPRINGBOOT_APPLICATION_ANNOTATION_NAME));
        for (String string2 : list2) {
            if (!list3.contains(string2)) continue;
            SpringbootPacker.of(jkPathSequence, path2, string2, string).makeExecJar(path, path3);
            return;
        }
        for (String string2 : list2) {
            String string3;
            if (!string2.endsWith("Kt") || !list3.contains(string3 = JkUtilsString.substringBeforeLast((String)string2, (String)"Kt"))) continue;
            SpringbootPacker.of(jkPathSequence, path2, string2, string).makeExecJar(path, path3);
            return;
        }
        throw new IllegalStateException("No class annotated with @SpringBootApplication found.");
    }

    @JkDoc(value={"Scaffold a basic example application in package org.example"})
    public void scaffoldSample() {
        String string = "your/basepackage";
        Path path = (Path)this.projectBean.getProject().compilation.layout.getSources().getRootDirsOrZipFiles().get(0);
        Path path2 = path.resolve(string);
        URL uRL = SpringbootJkBean.class.getClassLoader().getResource("src/snippet/Application.java");
        JkPathFile.of((Path)path2.resolve("Application.java")).createIfNotExist().fetchContentFrom(uRL);
        uRL = SpringbootJkBean.class.getClassLoader().getResource("src/snippet/Controller.java");
        JkPathFile.of((Path)path2.resolve("Controller.java")).createIfNotExist().fetchContentFrom(uRL);
        Path path3 = (Path)this.projectBean.getProject().testing.compilation.layout.getSources().getRootDirsOrZipFiles().get(0);
        path2 = path3.resolve(string);
        uRL = SpringbootJkBean.class.getClassLoader().getResource("src/snippet/ControllerIT.java");
        JkPathFile.of((Path)path2.resolve("ControllerIT.java")).createIfNotExist().fetchContentFrom(uRL);
        JkPathFile.of((Path)((Path)this.projectBean.getProject().compilation.layout.getResources().getRootDirsOrZipFiles().get(0)).resolve("application.properties")).createIfNotExist();
    }

    @JkDoc(value={"Provides info about this plugin configuration"})
    public void info() {
        JkLog.info((String)("Springboot version : " + this.springbootVersion), (Object[])new Object[0]);
        JkLog.info((String)("Create Bootable Jar : " + this.createBootJar), (Object[])new Object[0]);
        JkLog.info((String)("Create original Jar : " + this.createOriginalJar), (Object[])new Object[0]);
        JkLog.info((String)("Create .war file : " + this.createWarFile), (Object[])new Object[0]);
    }

    private String pluginVersion() {
        return JkManifest.of().loadFromClass(SpringbootJkBean.class).getMainAttribute("Implementation-Version");
    }

    private String latestSpringbootVersion(JkProject jkProject) {
        try {
            List list = jkProject.dependencyResolver.searchVersions(JkSpringModules.Boot.STARTER_PARENT);
            return (String)list.stream().sorted(JkVersion.VERSION_COMPARATOR.reversed()).findFirst().get();
        }
        catch (Exception exception) {
            JkLog.warn((String)exception.getMessage(), (Object[])new Object[0]);
            JkLog.warn((String)"Cannot find latest springboot version, choose default : 2.7.7", (Object[])new Object[0]);
            return DEFAULT_SPRINGBOOT_VERSION;
        }
    }

    public SpringbootJkBean setUseSpringRepos(boolean bl) {
        this.useSpringRepos = bl;
        return this;
    }
}

