/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.plugins.sonarqube.JkSonarqube;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

@JkDoc(value={"Run SonarQube analysis."})
public class SonarqubeJkBean
extends JkBean {
    @JkDoc(value={"If false, no sonar analysis will be performed"})
    public boolean enabled = true;
    @JkDoc(value={"If true, the list of production dependency files will be provided to sonarqube"})
    public boolean provideProductionLibs = true;
    @JkDoc(value={"If true, the list of test dependency files will be provided to sonarqube"})
    public boolean provideTestLibs = false;
    @JkDoc(value={"Version of the SonarQube client to run. It can be '+' for the latest one (at the price of a greater process time). The version will be resolved against 'org.sonarsource.scanner.cli:sonar-scanner-cli' coordinate. Use a blank string to use the client embedded in the plugin."})
    @JkDepSuggest(versionOnly=true, hint="org.sonarsource.scanner.cli:sonar-scanner-cli:")
    public String scannerVersion = "4.6.2.2472";
    @JkDoc(value={"If true, displays sonarqube output on console"})
    public boolean logOutput = true;
    private Consumer<JkSonarqube> sonarqubeConfigurer = jkSonarqube -> {};
    private Supplier<List<JkProject>> projectsSupplier = null;

    @JkDoc(value={"Runs sonarQube analysis based on properties defined in this plugin. Properties prefixed with 'sonar.' as '-sonar.host.url=http://myserver/..' will be appended to sonarQube properties."})
    public void run() {
        if (!this.enabled) {
            JkLog.info((String)"Sonarqube analysis has been disabled. No analysis will be performed.", (Object[])new Object[0]);
            return;
        }
        List<JkProject> list = this.projectsSupplier == null ? Collections.singletonList(((ProjectJkBean)this.getRuntime().getBean(ProjectJkBean.class)).getProject()) : this.projectsSupplier.get();
        for (JkProject jkProject : list) {
            JkSonarqube jkSonarqube = this.createConfiguredSonarqube(jkProject);
            this.sonarqubeConfigurer.accept(jkSonarqube);
            jkSonarqube.run();
        }
    }

    public SonarqubeJkBean configureProjectsToScan(Supplier<JkProject> ... supplierArray) {
        this.projectsSupplier = () -> {
            LinkedList linkedList = new LinkedList();
            for (Supplier supplier : supplierArray) {
                linkedList.add(supplier.get());
            }
            return linkedList;
        };
        return this;
    }

    public SonarqubeJkBean lately(Consumer<JkSonarqube> consumer) {
        this.sonarqubeConfigurer = consumer;
        return this;
    }

    private JkSonarqube createConfiguredSonarqube(JkProject jkProject) {
        return JkSonarqube.ofConfigured(jkProject, this.scannerVersion, this.provideProductionLibs, this.provideTestLibs).setLogOutput(this.logOutput).setProperties(this.getRuntime().getProperties().getAllStartingWith("sonar.", false));
    }
}

