/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.java.project.JkCompileLayout;
import dev.jeka.core.api.java.project.JkJavaProject;
import dev.jeka.core.api.java.project.JkJavaProjectConstruction;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkClass;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkDocPluginDeps;
import dev.jeka.core.tool.JkOptions;
import dev.jeka.core.tool.JkPlugin;
import dev.jeka.core.tool.builtins.java.JkPluginJava;
import dev.jeka.plugins.sonarqube.JkSonarqube;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

@JkDoc(value={"Run SonarQube analysis."})
@JkDocPluginDeps(value={JkPluginJava.class})
public class JkPluginSonarqube
extends JkPlugin {
    private final Map<String, String> properties = new HashMap<String, String>();
    @JkDoc(value={"If false, no sonar analysis will be performed"})
    public boolean enabled = true;
    @JkDoc(value={"If true, the list of production dependency files will be provided to sonarqube"})
    public boolean provideProductionLibs = true;
    @JkDoc(value={"If true, the list of test dependency files will be provided to sonarqube"})
    public boolean provideTestLibs = false;
    @JkDoc(value={"Version of the SonarQube client to run. It can be '+' for the latest one, at the price of a greater process time.\nUse a blank string to use the client embedded in the plugin."})
    public String scannerVersion = "4.6.2.2472";
    @JkDoc(value={"If true, displays sonarqube output on console"})
    public boolean logOutput = false;

    protected JkPluginSonarqube(JkClass jkClass) {
        super(jkClass);
    }

    private JkSonarqube createConfiguredSonarqube(JkJavaProject jkJavaProject) {
        String string;
        Path path;
        JkCompileLayout jkCompileLayout = jkJavaProject.getConstruction().getCompilation().getLayout();
        JkCompileLayout jkCompileLayout2 = jkJavaProject.getConstruction().getTesting().getCompilation().getLayout();
        Path path2 = jkJavaProject.getBaseDir();
        JkPathSequence jkPathSequence = JkPathSequence.of();
        JkJavaProjectConstruction jkJavaProjectConstruction = jkJavaProject.getConstruction();
        if (this.provideProductionLibs) {
            path = jkJavaProjectConstruction.getCompilation().getDependencies().merge(jkJavaProjectConstruction.getRuntimeDependencies()).getResult();
            jkPathSequence = jkJavaProject.getConstruction().getDependencyResolver().resolve((JkDependencySet)path).getFiles();
        }
        path = jkJavaProject.getConstruction().getTesting().getReportDir();
        JkModuleId jkModuleId = jkJavaProject.getPublication().getModuleId();
        if (jkModuleId == null) {
            string = path2.getFileName().toString();
            jkModuleId = JkModuleId.of((String)string, (String)string);
        }
        string = jkJavaProject.getPublication().getVersion();
        String string2 = jkModuleId.getDotedName();
        String string3 = jkModuleId.getName();
        JkSonarqube jkSonarqube = JkUtilsString.isBlank((String)this.scannerVersion) ? JkSonarqube.ofEmbedded() : JkSonarqube.ofVersion(jkJavaProject.getConstruction().getDependencyResolver().getRepos(), this.scannerVersion);
        jkSonarqube.setLogOutput(this.logOutput).setProjectId(string2, string3, string).setProperties(JkOptions.getAllStartingWith((String)"sonar.")).setProjectBaseDir(path2).setBinaries((Iterable<Path>)jkJavaProject.getConstruction().getCompilation().getLayout().resolveClassDir()).setProperty("sources", jkCompileLayout.resolveSources().getRootDirsOrZipFiles()).setProperty("tests", jkCompileLayout2.resolveSources().getRootDirsOrZipFiles()).setProperty("working.directory", path2.resolve("jeka/.sonar").toString()).setProperty("junit.reportsPath", path2.relativize(path.resolve("junit")).toString()).setProperty("surefire.reportsPath", path2.relativize(path.resolve("junit")).toString()).setProperty("sourceEncoding", jkJavaProject.getConstruction().getSourceEncoding()).setProperty("coverage.jacoco.xmlReportPaths", path2.relativize(jkJavaProject.getOutputDir().resolve("jacoco/jacoco.xml")).toString()).setProperty("java.libraries", (Iterable<Path>)jkPathSequence).setProperty("java.test.binaries", jkCompileLayout2.getClassDirPath());
        if (this.provideTestLibs) {
            JkDependencySet jkDependencySet = jkJavaProjectConstruction.getTesting().getCompilation().getDependencies();
            JkPathSequence jkPathSequence2 = jkJavaProject.getConstruction().getDependencyResolver().resolve(jkDependencySet).getFiles();
            jkSonarqube.setProperty("java.test.libraries", (Iterable<Path>)jkPathSequence2);
        }
        return jkSonarqube;
    }

    @JkDoc(value={"Runs sonar qube analysis based on properties defined in this plugin. Options prefixed set 'sonar.' as '-sonar.host.url=http://myserver/..' will be appended to sonarQube properties."})
    public void run() {
        if (!this.enabled) {
            JkLog.info((String)"Sonarqube analysis has been disabled. No analysis will be performed.", (Object[])new Object[0]);
            return;
        }
        JkJavaProject jkJavaProject = ((JkPluginJava)this.getJkClass().getPlugins().get(JkPluginJava.class)).getProject();
        JkSonarqube jkSonarqube = this.createConfiguredSonarqube(jkJavaProject).setProperties(this.properties);
        jkSonarqube.run();
    }
}

