/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.project.JkCompileLayout;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import dev.jeka.plugins.sonarqube.JkSonarqube;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

@JkDoc(value={"Run SonarQube analysis."})
public class SonarqubeJkBean
extends JkBean {
    private final Map<String, String> properties = new HashMap<String, String>();
    @JkDoc(value={"If false, no sonar analysis will be performed"})
    public boolean enabled = true;
    @JkDoc(value={"If true, the list of production dependency files will be provided to sonarqube"})
    public boolean provideProductionLibs = true;
    @JkDoc(value={"If true, the list of test dependency files will be provided to sonarqube"})
    public boolean provideTestLibs = false;
    @JkDoc(value={"Version of the SonarQube client to run. It can be '+' for the latest one, at the price of a greater process time.\nUse a blank string to use the client embedded in the plugin."})
    public String scannerVersion = "4.6.2.2472";
    @JkDoc(value={"If true, displays sonarqube output on console"})
    public boolean logOutput = true;
    private Consumer<JkSonarqube> sonarqubeConfigurer = jkSonarqube -> {};
    private Supplier<List<JkProject>> projectsSupplier = null;

    public JkSonarqube createConfiguredSonarqube(JkProject jkProject) {
        String string;
        Path path;
        JkCompileLayout jkCompileLayout = jkProject.getCompilation().getLayout();
        JkCompileLayout jkCompileLayout2 = jkProject.getTesting().getCompilation().getLayout();
        Path path2 = jkProject.getBaseDir();
        JkPathSequence jkPathSequence = JkPathSequence.of();
        if (this.provideProductionLibs) {
            path = jkProject.getCompilation().getDependencies().merge(jkProject.getPackaging().getRuntimeDependencies()).getResult();
            jkPathSequence = jkProject.getDependencyResolver().resolve((JkDependencySet)path).getFiles();
        }
        path = jkProject.getTesting().getReportDir();
        JkModuleId jkModuleId = jkProject.getPublication().getModuleId();
        if (jkModuleId == null) {
            string = path2.getFileName().toString();
            if (JkUtilsString.isBlank((String)string)) {
                string = path2.toAbsolutePath().getFileName().toString();
            }
            jkModuleId = JkModuleId.of((String)string, (String)string);
        }
        string = jkProject.getPublication().getVersion().getValue();
        String string2 = jkModuleId.getDotNotation();
        String string3 = jkModuleId.getName();
        JkSonarqube jkSonarqube = JkUtilsString.isBlank((String)this.scannerVersion) ? JkSonarqube.ofEmbedded() : JkSonarqube.ofVersion(jkProject.getDependencyResolver().getRepos(), this.scannerVersion);
        jkSonarqube.setLogOutput(this.logOutput).setProjectId(string2, string3, string).setProperties(this.getRuntime().getProperties().getAllStartingWith("sonar.", true)).setProjectBaseDir(path2).setBinaries((Iterable<Path>)jkProject.getCompilation().getLayout().resolveClassDir()).setProperty("sources", jkCompileLayout.resolveSources().getRootDirsOrZipFiles()).setProperty("tests", jkCompileLayout2.resolveSources().getRootDirsOrZipFiles()).setProperty("working.directory", path2.resolve("jeka/.sonar").toString()).setProperty("junit.reportsPath", path2.relativize(path.resolve("junit")).toString()).setProperty("surefire.reportsPath", path2.relativize(path.resolve("junit")).toString()).setProperty("sourceEncoding", jkProject.getSourceEncoding()).setProperty("coverage.jacoco.xmlReportPaths", path2.relativize(jkProject.getOutputDir().resolve("jacoco/jacoco.xml")).toString()).setProperty("java.libraries", (Iterable<Path>)jkPathSequence).setProperty("java.test.binaries", jkCompileLayout2.getClassDirPath());
        if (this.provideTestLibs) {
            JkDependencySet jkDependencySet = jkProject.getTesting().getCompilation().getDependencies();
            JkPathSequence jkPathSequence2 = jkProject.getDependencyResolver().resolve(jkDependencySet).getFiles();
            jkSonarqube.setProperty("java.test.libraries", (Iterable<Path>)jkPathSequence2);
        }
        return jkSonarqube;
    }

    @JkDoc(value={"Runs sonarQube analysis based on properties defined in this plugin. Properties prefixed with 'sonar.' as '-sonar.host.url=http://myserver/..' will be appended to sonarQube properties."})
    public void run() {
        if (!this.enabled) {
            JkLog.info((String)"Sonarqube analysis has been disabled. No analysis will be performed.", (Object[])new Object[0]);
            return;
        }
        List<JkProject> list = this.projectsSupplier == null ? Collections.singletonList(((ProjectJkBean)this.getRuntime().getBean(ProjectJkBean.class)).getProject()) : this.projectsSupplier.get();
        for (JkProject jkProject : list) {
            JkSonarqube jkSonarqube = this.createConfiguredSonarqube(jkProject);
            this.sonarqubeConfigurer.accept(jkSonarqube);
            jkSonarqube.run();
        }
    }

    public SonarqubeJkBean configureProjectsToScan(Supplier<JkProject> ... supplierArray) {
        this.projectsSupplier = () -> {
            LinkedList linkedList = new LinkedList();
            for (Supplier supplier : supplierArray) {
                linkedList.add(supplier.get());
            }
            return linkedList;
        };
        return this;
    }

    public SonarqubeJkBean configure(Consumer<JkSonarqube> consumer) {
        this.sonarqubeConfigurer = consumer;
        return this;
    }
}

