/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.project.JkCompileLayout;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectConstruction;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkClass;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkDocPluginDeps;
import dev.jeka.core.tool.JkOptions;
import dev.jeka.core.tool.JkPlugin;
import dev.jeka.core.tool.builtins.project.JkPluginProject;
import dev.jeka.plugins.sonarqube.JkSonarqube;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@JkDoc(value={"Run SonarQube analysis."})
@JkDocPluginDeps(value={JkPluginProject.class})
public class JkPluginSonarqube
extends JkPlugin {
    private final Map<String, String> properties = new HashMap<String, String>();
    @JkDoc(value={"If false, no sonar analysis will be performed"})
    public boolean enabled = true;
    @JkDoc(value={"If true, the list of production dependency files will be provided to sonarqube"})
    public boolean provideProductionLibs = true;
    @JkDoc(value={"If true, the list of test dependency files will be provided to sonarqube"})
    public boolean provideTestLibs = false;
    @JkDoc(value={"Version of the SonarQube client to run. It can be '+' for the latest one, at the price of a greater process time.\nUse a blank string to use the client embedded in the plugin."})
    public String scannerVersion = "4.6.2.2472";
    @JkDoc(value={"If true, displays sonarqube output on console"})
    public boolean logOutput = false;
    private Consumer<JkSonarqube> sonarqubeConfigurer = jkSonarqube -> {};

    protected JkPluginSonarqube(JkClass jkClass) {
        super(jkClass);
    }

    private JkSonarqube createConfiguredSonarqube(JkProject jkProject) {
        String string;
        Path path;
        JkCompileLayout jkCompileLayout = jkProject.getConstruction().getCompilation().getLayout();
        JkCompileLayout jkCompileLayout2 = jkProject.getConstruction().getTesting().getCompilation().getLayout();
        Path path2 = jkProject.getBaseDir();
        JkPathSequence jkPathSequence = JkPathSequence.of();
        JkProjectConstruction jkProjectConstruction = jkProject.getConstruction();
        if (this.provideProductionLibs) {
            path = jkProjectConstruction.getCompilation().getDependencies().merge(jkProjectConstruction.getRuntimeDependencies()).getResult();
            jkPathSequence = jkProject.getConstruction().getDependencyResolver().resolve((JkDependencySet)path).getFiles();
        }
        path = jkProject.getConstruction().getTesting().getReportDir();
        JkModuleId jkModuleId = jkProject.getPublication().getModuleId();
        if (jkModuleId == null) {
            string = path2.getFileName().toString();
            jkModuleId = JkModuleId.of((String)string, (String)string);
        }
        string = jkProject.getPublication().getVersion();
        String string2 = jkModuleId.getDotedName();
        String string3 = jkModuleId.getName();
        JkSonarqube jkSonarqube = JkUtilsString.isBlank((String)this.scannerVersion) ? JkSonarqube.ofEmbedded() : JkSonarqube.ofVersion(jkProject.getConstruction().getDependencyResolver().getRepos(), this.scannerVersion);
        jkSonarqube.setLogOutput(this.logOutput).setProjectId(string2, string3, string).setProperties(JkOptions.getAllStartingWith((String)"sonar.")).setProjectBaseDir(path2).setBinaries((Iterable<Path>)jkProject.getConstruction().getCompilation().getLayout().resolveClassDir()).setProperty("sources", jkCompileLayout.resolveSources().getRootDirsOrZipFiles()).setProperty("tests", jkCompileLayout2.resolveSources().getRootDirsOrZipFiles()).setProperty("working.directory", path2.resolve("jeka/.sonar").toString()).setProperty("junit.reportsPath", path2.relativize(path.resolve("junit")).toString()).setProperty("surefire.reportsPath", path2.relativize(path.resolve("junit")).toString()).setProperty("sourceEncoding", jkProject.getConstruction().getSourceEncoding()).setProperty("coverage.jacoco.xmlReportPaths", path2.relativize(jkProject.getOutputDir().resolve("jacoco/jacoco.xml")).toString()).setProperty("java.libraries", (Iterable<Path>)jkPathSequence).setProperty("java.test.binaries", jkCompileLayout2.getClassDirPath());
        if (this.provideTestLibs) {
            JkDependencySet jkDependencySet = jkProjectConstruction.getTesting().getCompilation().getDependencies();
            JkPathSequence jkPathSequence2 = jkProject.getConstruction().getDependencyResolver().resolve(jkDependencySet).getFiles();
            jkSonarqube.setProperty("java.test.libraries", (Iterable<Path>)jkPathSequence2);
        }
        return jkSonarqube;
    }

    @JkDoc(value={"Runs sonar qube analysis based on properties defined in this plugin. Options prefixed set 'sonar.' as '-sonar.host.url=http://myserver/..' will be appended to sonarQube properties."})
    public void run() {
        if (!this.enabled) {
            JkLog.info((String)"Sonarqube analysis has been disabled. No analysis will be performed.", (Object[])new Object[0]);
            return;
        }
        JkProject jkProject = ((JkPluginProject)this.getJkClass().getPlugins().get(JkPluginProject.class)).getProject();
        JkSonarqube jkSonarqube = this.createConfiguredSonarqube(jkProject);
        this.sonarqubeConfigurer.accept(jkSonarqube);
        jkSonarqube.run();
    }

    public void configure(Consumer<JkSonarqube> consumer) {
        this.sonarqubeConfigurer = consumer;
    }
}

