/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.KBean;
import dev.jeka.core.tool.builtins.project.ProjectKBean;
import dev.jeka.plugins.sonarqube.JkSonarqube;

@JkDoc(value="Run SonarQube analysis.")
public class SonarqubeKBean
extends KBean {
    @JkDoc(value="If true, the list of production dependency files will be provided to sonarqube")
    public boolean provideProductionLibs = true;
    @JkDoc(value="If true, the list of test dependency files will be provided to sonarqube")
    public boolean provideTestLibs = false;
    @JkDoc(value="Version of the SonarQube client to run. It can be '+' for the latest one (at the price of a greater process time). The version will be resolved against 'org.sonarsource.scanner.cli:sonar-scanner-cli' coordinate. Use a blank string to use the client embedded in the plugin.")
    @JkDepSuggest(versionOnly=true, hint="org.sonarsource.scanner.cli:sonar-scanner-cli:")
    public String scannerVersion = "5.0.1.3006";
    @JkDoc(value="If true, displays sonarqube output on console")
    public boolean logOutput = true;
    @JkDoc(value="Ping the sonarqube server prior running analysis")
    public boolean pingServer = true;
    public final JkSonarqube sonarqube = JkSonarqube.ofVersion(this.getRunbase().getDependencyResolver().getRepos(), "5.0.1.3006");

    @JkDoc(value="Runs sonarQube analysis based on properties defined in this plugin. Properties prefixed with 'sonar.' as '-sonar.host.url=http://myserver/..' will be appended to sonarQube properties.")
    public void run() {
        this.getRunbase().find(ProjectKBean.class).ifPresent(projectKBean -> this.sonarqube.configureFor(projectKBean.project, this.provideProductionLibs, this.provideTestLibs));
        this.sonarqube.run();
    }

    protected void init() {
        this.sonarqube.setVersion(this.getRunbase().getDependencyResolver().getRepos(), this.effectiveScannerVersion());
        this.sonarqube.setPingServer(this.pingServer);
        this.sonarqube.setLogOutput(this.logOutput);
        this.sonarqube.setProperties(this.getRunbase().getProperties());
    }

    private String effectiveScannerVersion() {
        return JkUtilsString.isBlank((String)this.scannerVersion) ? "5.0.1.3006" : this.scannerVersion;
    }
}

