/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkDepSuggest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.KBean;
import dev.jeka.core.tool.builtins.project.ProjectKBean;
import dev.jeka.plugins.sonarqube.JkSonarqube;
import java.nio.file.Files;
import java.nio.file.LinkOption;

@JkDoc(value="Run Sonarqube analysis and check quality gates. \nThe properties prefixed with 'sonar.', such as '-Dsonar.host.url=http://myserver/..', will be appended to the SonarQube configuration.")
public class SonarqubeKBean
extends KBean {
    private JkProject project;
    @JkDoc(value="If true, the list of production dependency files will be provided to sonarqube")
    public boolean provideProductionLibs = true;
    @JkDoc(value="If true, the list of test dependency files will be provided to sonarqube")
    public boolean provideTestLibs = false;
    @JkDoc(value="Version of the SonarQube client to run. It can be '+' for the latest one (at the price of a greater process time). The version will be resolved against 'org.sonarsource.scanner.cli:sonar-scanner-cli' coordinate. Use a blank string to use the client embedded in the plugin.")
    @JkDepSuggest(versionOnly=true, hint="org.sonarsource.scanner.cli:sonar-scanner-cli:")
    public String scannerVersion = "5.0.1.3006";
    @JkDoc(value="If true, displays sonarqube output on console")
    public boolean logOutput = true;
    @JkDoc(value="Ping the sonarqube server prior running analysis")
    public boolean pingServer = true;
    public final JkSonarqube sonarqube = JkSonarqube.ofVersion(this.getRunbase().getDependencyResolver().getRepos(), "5.0.1.3006");

    @JkDoc(value="Runs a SonarQube analysis and sends the results to a Sonar server.")
    public void run() {
        JkUtilsAssert.state((this.project != null ? 1 : 0) != 0, (String)"Np project to analyse found in %s", (Object[])new Object[]{this.getBaseDir()});
        JkUtilsAssert.state((boolean)Files.exists(this.project.compilation.layout.resolveClassDir(), new LinkOption[0]), (String)"Project class directory not found. Please run compilation and tests prior running analysis.", (Object[])new Object[0]);
        this.sonarqube.configureFor(this.project, this.provideProductionLibs, this.provideTestLibs);
        this.sonarqube.run();
    }

    @JkDoc(value="Checks if the analysed project passes its quality gates. The 'run' method is expected to have already been executed.")
    public void check() {
        JkUtilsAssert.state((this.project != null ? 1 : 0) != 0, (String)"Np project to analyse found in %s", (Object[])new Object[]{this.getBaseDir()});
        JkSonarqube.QualityGateResponse response = this.sonarqube.checkQualityGate();
        if (response.success) {
            JkLog.info((String)"Sonarqube quality gate passed successfully.", (Object[])new Object[0]);
        } else {
            JkLog.error((String)"Project does not meet quality gate criteria. See %s/dashboard?id=%s", (Object[])new Object[]{this.sonarqube.getHostUrl(), this.sonarqube.getProperty("projectKey")});
            System.exit(1);
        }
    }

    protected void init() {
        this.sonarqube.setVersion(this.getRunbase().getDependencyResolver().getRepos(), this.effectiveScannerVersion());
        this.sonarqube.setPingServer(this.pingServer);
        this.sonarqube.setLogOutput(this.logOutput);
        this.sonarqube.setProperties(this.getRunbase().getProperties());
        this.getRunbase().find(ProjectKBean.class).ifPresent(projectKBean -> {
            this.project = projectKBean.project;
        });
    }

    private String effectiveScannerVersion() {
        return JkUtilsString.isBlank((String)this.scannerVersion) ? "5.0.1.3006" : this.scannerVersion;
    }
}

