/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkCoordinate;
import dev.jeka.core.api.depmanagement.JkCoordinateDependency;
import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.java.JkInternalEmbeddedClassloader;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.project.JkCompileLayout;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProperties;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public final class JkSonarqube {
    public static final String PROJECT_KEY = "projectKey";
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String LANGUAGE = "language";
    public static final String PROFILE = "profile";
    public static final String BRANCH = "branch";
    public static final String TOKEN = "token";
    public static final String SOURCE_ENCODING = "sourceEncoding";
    public static final String VERBOSE = "verbose";
    public static final String WORKING_DIRECTORY = "working.directory";
    public static final String JUNIT_REPORTS_PATH = "junit.reportsPath";
    public static final String SUREFIRE_REPORTS_PATH = "surefire.reportsPath";
    public static final String JACOCO_LEGACY_REPORTS_PATHS = "jacoco.reportPaths";
    public static final String JACOCO_XML_REPORTS_PATHS = "coverage.jacoco.xmlReportPaths";
    public static final String COVERTURA_REPORTS_PATH = "cobertura.reportPath";
    public static final String CLOVER_REPORTS_PATH = "clover.reportPath";
    public static final String DYNAMIC_ANALYSIS = "dynamicAnalysis";
    public static final String PROJECT_BASE_DIR = "projectBaseDir";
    public static final String SOURCES = "sources";
    public static final String BINARIES = "binaries";
    public static final String JAVA_BINARIES = "java.binaries";
    public static final String TEST = "tests";
    public static final String LIBRARIES = "libraries";
    public static final String JAVA_LIBRARIES = "java.libraries";
    public static final String JAVA_TEST_LIBRARIES = "java.test.libraries";
    public static final String JAVA_TEST_BINARIES = "java.test.binaries";
    public static final String SKIP_DESIGN = "skipDesign";
    public static final String HOST_URL = "host.url";
    public static final String JDBC_URL = "jdbc.url";
    public static final String JDBC_USERNAME = "jdbc.username";
    public static final String JDBC_PASSWORD = "jdbc.password";
    private static final String SCANNER_JAR_NAME_46 = "sonar-scanner-cli-4.6.2.2472.jar";
    private static final String SONAR_PREFIX = "sonar.";
    private final Map<String, String> params = new HashMap<String, String>();
    private final JkRepoSet repos;
    private final String scannerVersion;
    private boolean logOutput;

    private JkSonarqube(JkRepoSet repos, String scannerVersion) {
        this.repos = repos;
        this.scannerVersion = scannerVersion;
        this.params.put(WORKING_DIRECTORY, JkSonarqube.workDir(Paths.get("", new String[0])));
    }

    public static JkSonarqube ofEmbedded() {
        return new JkSonarqube(null, null);
    }

    public static JkSonarqube ofVersion(JkRepoSet repos, String scannerVersion) {
        return new JkSonarqube(repos, scannerVersion);
    }

    public static JkSonarqube ofVersion(JkDependencyResolver dependencyResolver, String scannerVersion) {
        return new JkSonarqube(dependencyResolver.getRepos(), scannerVersion);
    }

    public static JkSonarqube ofVersion(String scannerVersion) {
        return JkSonarqube.ofVersion(JkRepo.ofMavenCentral().toSet(), scannerVersion);
    }

    private static String workDir(Path baseDir) {
        return baseDir.resolve("jeka/.sonarscannerworks").toString();
    }

    public JkSonarqube configureFor(JkProject project) {
        return this.configureFor(project, true, false);
    }

    public JkSonarqube setProjectId(String projectKey, String projectName, String version) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROJECT_KEY, projectKey);
        map.put(PROJECT_NAME, projectName);
        map.put(PROJECT_VERSION, version);
        Properties properties = System.getProperties();
        for (Object keyObject : properties.keySet()) {
            String key = (String)keyObject;
            if (!key.startsWith(SONAR_PREFIX)) continue;
            map.put(key.substring(SONAR_PREFIX.length()), properties.getProperty(key));
        }
        this.setProperties(map);
        return this;
    }

    public JkSonarqube setLogOutput(boolean logOutput) {
        this.logOutput = logOutput;
        return this;
    }

    public void run() {
        String[] stringArray;
        String hostUrl = Optional.ofNullable(this.params.get(HOST_URL)).orElse("localhost");
        JkLog.startTask((String)("Launch Sonar analysis on server " + hostUrl), (Object[])new Object[0]);
        Path jar = this.getToolJar();
        if (JkLog.isVerbose()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "-e";
            stringArray = stringArray2;
            stringArray2[1] = "-X";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "-e";
        }
        String[] args = stringArray;
        this.javaProcess(jar, "org.sonarsource.scanner.cli.Main").exec(args);
        JkLog.endTask();
    }

    public JkSonarqube setProperty(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public JkSonarqube setProperty(String key, Iterable<Path> value) {
        return this.setProperty(key, this.toPaths(value));
    }

    public JkSonarqube setProperties(Map<String, String> props) {
        this.params.putAll(props);
        return this;
    }

    public JkSonarqube setProperties(JkProperties properties) {
        this.setProperties(properties.getAllStartingWith(SONAR_PREFIX, false));
        return this;
    }

    public JkSonarqube setProjectBaseDir(Path baseDir) {
        return this.setProperty(PROJECT_BASE_DIR, baseDir.toAbsolutePath().toString());
    }

    public JkSonarqube setBinaries(Iterable<Path> files) {
        String path = this.toPaths(JkUtilsPath.disambiguate(files));
        return this.setProperty(BINARIES, path).setProperty(JAVA_BINARIES, path);
    }

    public JkSonarqube setBinaries(Path ... files) {
        return this.setBinaries(Arrays.asList(files));
    }

    public JkSonarqube setSkipDesign(boolean skip) {
        return this.setProperty(SKIP_DESIGN, Boolean.toString(skip));
    }

    public JkSonarqube setHostUrl(String url) {
        return this.setProperty(HOST_URL, url);
    }

    public JkSonarqube setJdbcUrl(String url) {
        return this.setProperty(JDBC_URL, url);
    }

    public JkSonarqube setJdbcUserName(String userName) {
        return this.setProperty(JDBC_USERNAME, userName);
    }

    public JkSonarqube setJdbcPassword(String pwd) {
        return this.setProperty(JDBC_PASSWORD, pwd);
    }

    private JkJavaProcess javaProcess(Path jar, String mainClassName) {
        return (JkJavaProcess)((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJava((String)mainClassName).setClasspath((Iterable)jar).setFailOnError(true)).addParams(this.toProperties())).setLogCommand(JkLog.isVerbose() || this.logOutput)).setLogOutput(JkLog.isVerbose() || this.logOutput);
    }

    private List<String> toProperties() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(SONAR_PREFIX)) {
                key = SONAR_PREFIX + key;
            }
            result.add("-D" + key + "=" + entry.getValue());
        }
        return result;
    }

    private String toPaths(Iterable<Path> files) {
        Iterator it = JkUtilsPath.disambiguate(files).iterator();
        StringBuilder result = new StringBuilder();
        Path projectDir = this.projectDir();
        while (it.hasNext()) {
            Path file = (Path)it.next();
            String path = file.startsWith(projectDir) ? projectDir.relativize(file).normalize().toString() : file.toAbsolutePath().normalize().toString();
            result.append(path);
            if (!it.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private Path projectDir() {
        return Paths.get(this.params.get(PROJECT_BASE_DIR), new String[0]);
    }

    private Path getToolJar() {
        JkJavaVersion javaVersion = JkJavaVersion.of((String)System.getProperty("java.version"));
        JkUtilsAssert.state((javaVersion.compareTo(JkJavaVersion.V11) >= 0 ? 1 : 0) != 0, (String)("Sonarqube has to run on JRE >= 11. You are running on version " + javaVersion), (Object[])new Object[0]);
        if (this.scannerVersion == null) {
            URL embeddedUrl = JkSonarqube.class.getResource(SCANNER_JAR_NAME_46);
            JkLog.info((String)"Use embedded sonar scanner : sonar-scanner-cli-4.6.2.2472.jar", (Object[])new Object[0]);
            return JkUtilsIO.copyUrlContentToCacheFile((URL)embeddedUrl, null, (Path)JkInternalEmbeddedClassloader.URL_CACHE_DIR);
        }
        JkCoordinate coordinate = JkCoordinate.of((String)"org.sonarsource.scanner.cli", (String)"sonar-scanner-cli", (String)this.scannerVersion);
        JkCoordinateDependency coordinateDependency = JkCoordinateDependency.of((JkCoordinate)coordinate).withTransitivity(JkTransitivity.NONE);
        JkDependencyResolver dependencyResolver = JkDependencyResolver.of((JkRepoSet)this.repos);
        dependencyResolver.getDefaultParams().setFailOnDependencyResolutionError(false);
        JkResolveResult resolveResult = dependencyResolver.resolve(JkDependencySet.of().and(new JkDependency[]{coordinateDependency}));
        if (resolveResult.getErrorReport().hasErrors()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot find dependency " + coordinate + "\n");
            List versions = dependencyResolver.searchVersions(coordinate.getModuleId());
            sb.append("Known versions are : \n");
            versions.forEach(name -> sb.append(name + "\n"));
            throw new IllegalStateException(sb.toString());
        }
        JkVersion effectiveVersion = resolveResult.getVersionOf(coordinate.getModuleId());
        JkLog.info((String)("Run sonar scanner " + effectiveVersion), (Object[])new Object[0]);
        return (Path)resolveResult.getFiles().getEntries().get(0);
    }

    public JkSonarqube configureFor(JkProject project, boolean provideProdLibs, boolean provideTestLibs) {
        JkCompileLayout prodLayout = project.compilation.layout;
        JkCompileLayout testLayout = project.testing.compilation.layout;
        Path baseDir = project.getBaseDir();
        JkPathSequence libs = JkPathSequence.of();
        if (provideProdLibs) {
            JkDependencySet deps = project.compilation.getDependencies().merge(project.packaging.getRuntimeDependencies()).getResult();
            libs = project.dependencyResolver.resolve(deps).getFiles();
        }
        Path testReportDir = project.testing.getReportDir();
        JkModuleId jkModuleId = project.publication.getModuleId();
        if (jkModuleId == null) {
            String baseDirName = baseDir.getFileName().toString();
            if (JkUtilsString.isBlank((String)baseDirName)) {
                baseDirName = baseDir.toAbsolutePath().getFileName().toString();
            }
            jkModuleId = JkModuleId.of((String)baseDirName, (String)baseDirName);
        }
        String version = project.publication.getVersion().getValue();
        String fullName = jkModuleId.getDotNotation();
        String name = jkModuleId.getName();
        this.setLogOutput(JkLog.isVerbose()).setProjectId(fullName, name, version).setProjectBaseDir(baseDir).setBinaries((Iterable<Path>)project.compilation.layout.resolveClassDir()).setProperty(VERBOSE, Boolean.toString(JkLog.isVerbose())).setProperty(SOURCES, prodLayout.resolveSources().getRootDirsOrZipFiles()).setProperty(TEST, testLayout.resolveSources().getRootDirsOrZipFiles()).setProperty(WORKING_DIRECTORY, JkSonarqube.workDir(baseDir)).setProperty(JUNIT_REPORTS_PATH, baseDir.relativize(testReportDir.resolve("junit")).toString()).setProperty(SUREFIRE_REPORTS_PATH, baseDir.relativize(testReportDir.resolve("junit")).toString()).setProperty(SOURCE_ENCODING, project.getSourceEncoding()).setProperty(JACOCO_XML_REPORTS_PATHS, baseDir.relativize(project.getOutputDir().resolve("jacoco/jacoco.xml")).toString()).setProperty(JAVA_LIBRARIES, (Iterable<Path>)libs).setProperty(JAVA_TEST_BINARIES, testLayout.getClassDirPath());
        if (provideTestLibs) {
            JkDependencySet deps = project.testing.compilation.getDependencies();
            JkPathSequence testLibs = project.dependencyResolver.resolve(deps).getFiles();
            this.setProperty(JAVA_TEST_LIBRARIES, (Iterable<Path>)testLibs);
        }
        return this;
    }
}

