/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.plugins.sonarqube;

import dev.jeka.core.api.depmanagement.JkCoordinate;
import dev.jeka.core.api.depmanagement.JkCoordinateDependency;
import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.java.JkInternalEmbeddedClassloader;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public final class JkSonarqube {
    public static final String PROJECT_KEY = "projectKey";
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String LANGUAGE = "language";
    public static final String PROFILE = "profile";
    public static final String BRANCH = "branch";
    public static final String SOURCE_ENCODING = "sourceEncoding";
    public static final String VERBOSE = "verbose";
    public static final String WORKING_DIRECTORY = "working.directory";
    public static final String JUNIT_REPORTS_PATH = "junit.reportsPath";
    public static final String SUREFIRE_REPORTS_PATH = "surefire.reportsPath";
    public static final String JACOCO_LEGACY_REPORTS_PATHS = "jacoco.reportPaths";
    public static final String JACOCO_XML_REPORTS_PATHS = "coverage.jacoco.xmlReportPaths";
    public static final String COVERTURA_REPORTS_PATH = "cobertura.reportPath";
    public static final String CLOVER_REPORTS_PATH = "clover.reportPath";
    public static final String DYNAMIC_ANALYSIS = "dynamicAnalysis";
    public static final String PROJECT_BASE_DIR = "projectBaseDir";
    public static final String SOURCES = "sources";
    public static final String BINARIES = "binaries";
    public static final String JAVA_BINARIES = "java.binaries";
    public static final String TEST = "tests";
    public static final String LIBRARIES = "libraries";
    public static final String JAVA_LIBRARIES = "java.libraries";
    public static final String JAVA_TEST_LIBRARIES = "java.test.libraries";
    public static final String JAVA_TEST_BINARIES = "java.test.binaries";
    public static final String SKIP_DESIGN = "skipDesign";
    public static final String HOST_URL = "host.url";
    public static final String JDBC_URL = "jdbc.url";
    public static final String JDBC_USERNAME = "jdbc.username";
    public static final String JDBC_PASSWORD = "jdbc.password";
    private static final String SCANNER_JAR_NAME_46 = "sonar-scanner-cli-4.6.2.2472.jar";
    private static final String SONAR_PREFIX = "sonar.";
    private final Map<String, String> params = new HashMap<String, String>();
    private final JkRepoSet repos;
    private final String sonnarScannerVersion;
    private boolean logOutput;

    private JkSonarqube(JkRepoSet jkRepoSet, String string) {
        this.repos = jkRepoSet;
        this.sonnarScannerVersion = string;
    }

    public static JkSonarqube ofEmbedded() {
        return new JkSonarqube(null, null);
    }

    public static JkSonarqube ofVersion(JkRepoSet jkRepoSet, String string) {
        return new JkSonarqube(jkRepoSet, string);
    }

    public static JkSonarqube ofVersion(String string) {
        return JkSonarqube.ofVersion(JkRepo.ofMavenCentral().toSet(), string);
    }

    public JkSonarqube setProjectId(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROJECT_KEY, string);
        hashMap.put(PROJECT_NAME, string2);
        hashMap.put(PROJECT_VERSION, string3);
        hashMap.put(WORKING_DIRECTORY, ".sonarTempDir");
        hashMap.put(VERBOSE, Boolean.toString(JkLog.Verbosity.VERBOSE == JkLog.verbosity()));
        Properties properties = System.getProperties();
        for (Object object : properties.keySet()) {
            String string4 = (String)object;
            if (!string4.startsWith(SONAR_PREFIX)) continue;
            hashMap.put(string4.substring(SONAR_PREFIX.length()), properties.getProperty(string4));
        }
        this.setProperties(hashMap);
        return this;
    }

    public JkSonarqube setLogOutput(boolean bl) {
        this.logOutput = bl;
        return this;
    }

    public void run() {
        String[] stringArray;
        String string = Optional.ofNullable(this.params.get(HOST_URL)).orElse("localhost");
        JkLog.startTask((String)("Launch Sonar analysis on server " + string), (Object[])new Object[0]);
        Path path = this.getToolJar();
        if (JkLog.isVerbose()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "-e";
            stringArray = stringArray2;
            stringArray2[1] = "-X";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "-e";
        }
        String[] stringArray4 = stringArray;
        this.javaProcess(path, "org.sonarsource.scanner.cli.Main").exec(stringArray4);
        JkLog.endTask();
    }

    private JkJavaProcess javaProcess(Path path, String string) {
        return (JkJavaProcess)((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)JkJavaProcess.ofJava((String)string).setClasspath((Iterable)path).setFailOnError(true)).addParams(this.toProperties())).setLogCommand(JkLog.isVerbose() || this.logOutput)).setLogOutput(JkLog.isVerbose() || this.logOutput);
    }

    private List<String> toProperties() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            linkedList.add("-Dsonar." + entry.getKey() + "=" + entry.getValue());
        }
        return linkedList;
    }

    public JkSonarqube setProperty(String string, String string2) {
        this.params.put(string, string2);
        return this;
    }

    public JkSonarqube setProperty(String string, Iterable<Path> iterable) {
        return this.setProperty(string, this.toPaths(iterable));
    }

    public JkSonarqube setProperties(Map<String, String> map) {
        this.params.putAll(map);
        return this;
    }

    public JkSonarqube setProjectBaseDir(Path path) {
        return this.setProperty(PROJECT_BASE_DIR, path.toAbsolutePath().toString());
    }

    public JkSonarqube setBinaries(Iterable<Path> iterable) {
        String string = this.toPaths(JkUtilsPath.disambiguate(iterable));
        return this.setProperty(BINARIES, string).setProperty(JAVA_BINARIES, string);
    }

    public JkSonarqube setBinaries(Path ... pathArray) {
        return this.setBinaries(Arrays.asList(pathArray));
    }

    public JkSonarqube setSkipDesign(boolean bl) {
        return this.setProperty(SKIP_DESIGN, Boolean.toString(bl));
    }

    public JkSonarqube setHostUrl(String string) {
        return this.setProperty(HOST_URL, string);
    }

    public JkSonarqube setJdbcUrl(String string) {
        return this.setProperty(JDBC_URL, string);
    }

    public JkSonarqube setJdbcUserName(String string) {
        return this.setProperty(JDBC_USERNAME, string);
    }

    public JkSonarqube setJdbcPassword(String string) {
        return this.setProperty(JDBC_PASSWORD, string);
    }

    private String toPaths(Iterable<Path> iterable) {
        Iterator iterator = JkUtilsPath.disambiguate(iterable).iterator();
        StringBuilder stringBuilder = new StringBuilder();
        Path path = this.projectDir();
        while (iterator.hasNext()) {
            Path path2 = (Path)iterator.next();
            String string = path2.startsWith(path) ? path.relativize(path2).normalize().toString() : path2.toAbsolutePath().normalize().toString();
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private Path projectDir() {
        return Paths.get(this.params.get(PROJECT_BASE_DIR), new String[0]);
    }

    private Path getToolJar() {
        JkJavaVersion jkJavaVersion = JkJavaVersion.of((String)System.getProperty("java.version"));
        JkUtilsAssert.state((jkJavaVersion.compareTo(JkJavaVersion.V11) >= 0 ? 1 : 0) != 0, (String)("Sonarqube has to run on JRE >= 11. You are running on version " + jkJavaVersion), (Object[])new Object[0]);
        if (this.sonnarScannerVersion == null) {
            URL uRL = JkSonarqube.class.getResource(SCANNER_JAR_NAME_46);
            JkLog.info((String)"Use embedded sonar scanner : sonar-scanner-cli-4.6.2.2472.jar", (Object[])new Object[0]);
            return JkUtilsIO.copyUrlContentToCacheFile((URL)uRL, null, (Path)JkInternalEmbeddedClassloader.URL_CACHE_DIR);
        }
        JkCoordinate jkCoordinate = JkCoordinate.of((String)"org.sonarsource.scanner.cli", (String)"sonar-scanner-cli", (String)this.sonnarScannerVersion);
        JkCoordinateDependency jkCoordinateDependency = JkCoordinateDependency.of((JkCoordinate)jkCoordinate).withTransitivity(JkTransitivity.NONE);
        JkDependencyResolver jkDependencyResolver = JkDependencyResolver.of((JkRepoSet)this.repos);
        jkDependencyResolver.getDefaultParams().setFailOnDependencyResolutionError(false);
        JkResolveResult jkResolveResult = jkDependencyResolver.resolve(JkDependencySet.of().and(new JkDependency[]{jkCoordinateDependency}));
        if (jkResolveResult.getErrorReport().hasErrors()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot find dependency " + jkCoordinate + "\n");
            List list = jkDependencyResolver.searchVersions(jkCoordinate.getModuleId());
            stringBuilder.append("Known versions are : \n");
            list.forEach(string -> stringBuilder.append(string + "\n"));
            throw new IllegalStateException(stringBuilder.toString());
        }
        JkVersion jkVersion = jkResolveResult.getVersionOf(jkCoordinate.getModuleId());
        JkLog.info((String)("Run sonar scanner " + jkVersion), (Object[])new Object[0]);
        return (Path)jkResolveResult.getFiles().getEntries().get(0);
    }
}

